/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;

public class XMLAttributesImpl
implements XMLAttributes {
    protected boolean fNamespaces = true;
    protected int fLength;
    protected Attribute[] fAttributes = new Attribute[4];
    protected Augmentations[] fAugmentations = new AugmentationsImpl[4];

    public XMLAttributesImpl() {
        int n2 = 0;
        while (n2 < this.fAttributes.length) {
            this.fAttributes[n2] = new Attribute();
            this.fAugmentations[n2] = new AugmentationsImpl();
            ++n2;
        }
    }

    public void setNamespaces(boolean bl) {
        this.fNamespaces = bl;
    }

    public int addAttribute(QName qName, String string, String string2) {
        Attribute[] attributeArray;
        int n2;
        int n3 = n2 = qName.uri != null && !qName.uri.equals("") ? this.getIndex(qName.uri, qName.localpart) : this.getIndex(qName.rawname);
        if (n2 == -1) {
            n2 = this.fLength;
            if (this.fLength++ == this.fAttributes.length) {
                attributeArray = new Attribute[this.fAttributes.length + 4];
                AugmentationsImpl[] augmentationsImplArray = new AugmentationsImpl[this.fAttributes.length + 4];
                System.arraycopy(this.fAttributes, 0, attributeArray, 0, this.fAttributes.length);
                System.arraycopy(this.fAugmentations, 0, augmentationsImplArray, 0, this.fAttributes.length);
                int n4 = this.fAttributes.length;
                while (n4 < attributeArray.length) {
                    attributeArray[n4] = new Attribute();
                    augmentationsImplArray[n4] = new AugmentationsImpl();
                    ++n4;
                }
                this.fAttributes = attributeArray;
                this.fAugmentations = augmentationsImplArray;
            }
        }
        this.fAugmentations[n2].removeAllItems();
        attributeArray = this.fAttributes[n2];
        attributeArray.name.setValues(qName);
        attributeArray.type = string;
        attributeArray.value = string2;
        attributeArray.nonNormalizedValue = string2;
        attributeArray.specified = false;
        return n2;
    }

    public void removeAllAttributes() {
        this.fLength = 0;
    }

    public void removeAttributeAt(int n2) {
        if (n2 < this.fLength - 1) {
            Attribute attribute = this.fAttributes[n2];
            Augmentations augmentations = this.fAugmentations[n2];
            System.arraycopy(this.fAttributes, n2 + 1, this.fAttributes, n2, this.fLength - n2 - 1);
            System.arraycopy(this.fAugmentations, n2 + 1, this.fAugmentations, n2, this.fLength - n2 - 1);
            this.fAttributes[this.fLength - 1] = attribute;
            this.fAugmentations[this.fLength - 1] = augmentations;
        }
        --this.fLength;
    }

    public void setName(int n2, QName qName) {
        this.fAttributes[n2].name.setValues(qName);
    }

    public void getName(int n2, QName qName) {
        qName.setValues(this.fAttributes[n2].name);
    }

    public void setType(int n2, String string) {
        this.fAttributes[n2].type = string;
    }

    public void setValue(int n2, String string) {
        Attribute attribute = this.fAttributes[n2];
        attribute.value = string;
        attribute.nonNormalizedValue = string;
    }

    public void setNonNormalizedValue(int n2, String string) {
        if (string == null) {
            string = this.fAttributes[n2].value;
        }
        this.fAttributes[n2].nonNormalizedValue = string;
    }

    public String getNonNormalizedValue(int n2) {
        String string = this.fAttributes[n2].nonNormalizedValue;
        return string;
    }

    public void setSpecified(int n2, boolean bl) {
        this.fAttributes[n2].specified = bl;
    }

    public boolean isSpecified(int n2) {
        return this.fAttributes[n2].specified;
    }

    public int getLength() {
        return this.fLength;
    }

    public String getType(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n2].type;
        if (string.indexOf(40) == 0 && string.lastIndexOf(41) == string.length() - 1) {
            return "NMTOKEN";
        }
        return string;
    }

    public String getType(String string) {
        int n2 = this.getIndex(string);
        return n2 != -1 ? this.fAttributes[n2].type : null;
    }

    public String getValue(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].value;
    }

    public String getValue(String string) {
        int n2 = this.getIndex(string);
        return n2 != -1 ? this.fAttributes[n2].value : null;
    }

    public String getName(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].name.rawname;
    }

    public int getIndex(String string) {
        int n2 = 0;
        while (n2 < this.fLength) {
            Attribute attribute = this.fAttributes[n2];
            if (attribute.name.rawname != null && attribute.name.rawname.equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getIndex(String string, String string2) {
        int n2 = 0;
        while (n2 < this.fLength) {
            Attribute attribute = this.fAttributes[n2];
            if (attribute.name.localpart != null && attribute.name.localpart.equals(string2) && (string == attribute.name.uri || string != null && attribute.name.uri != null && attribute.name.uri.equals(string))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public String getLocalName(int n2) {
        if (!this.fNamespaces) {
            return "";
        }
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].name.localpart;
    }

    public String getQName(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n2].name.rawname;
        return string != null ? string : "";
    }

    public String getType(String string, String string2) {
        if (!this.fNamespaces) {
            return null;
        }
        int n2 = this.getIndex(string, string2);
        return n2 != -1 ? this.getType(n2) : null;
    }

    public String getPrefix(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n2].name.prefix;
        return string != null ? string : "";
    }

    public String getURI(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string = this.fAttributes[n2].name.uri;
        return string;
    }

    public String getValue(String string, String string2) {
        int n2 = this.getIndex(string, string2);
        return n2 != -1 ? this.getValue(n2) : null;
    }

    public Augmentations getAugmentations(String string, String string2) {
        int n2 = this.getIndex(string, string2);
        return n2 != -1 ? this.fAugmentations[n2] : null;
    }

    public Augmentations getAugmentations(String string) {
        int n2 = this.getIndex(string);
        return n2 != -1 ? this.fAugmentations[n2] : null;
    }

    public Augmentations getAugmentations(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAugmentations[n2];
    }

    public void setAugmentations(int n2, Augmentations augmentations) {
        this.fAugmentations[n2] = augmentations;
    }

    public void setURI(int n2, String string) {
        this.fAttributes[n2].name.uri = string;
    }

    public void setSchemaId(int n2, boolean bl) {
        this.fAttributes[n2].schemaId = bl;
    }

    public boolean getSchemaId(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return false;
        }
        return this.fAttributes[n2].schemaId;
    }

    public boolean getSchemaId(String string) {
        int n2 = this.getIndex(string);
        return n2 != -1 ? this.fAttributes[n2].schemaId : false;
    }

    public boolean getSchemaId(String string, String string2) {
        if (!this.fNamespaces) {
            return false;
        }
        int n2 = this.getIndex(string, string2);
        return n2 != -1 ? this.fAttributes[n2].schemaId : false;
    }

    static class Attribute {
        public QName name = new QName();
        public String type;
        public String value;
        public String nonNormalizedValue;
        public boolean specified;
        public boolean schemaId;

        Attribute() {
        }
    }
}

