/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;

public class XSAllCM
implements XSCMValidator {
    private static final short STATE_START = 0;
    private static final short STATE_VALID = 1;
    private static final short STATE_CHILD = 1;
    private XSElementDecl[] fAllElements;
    private boolean[] fIsOptionalElement;
    private boolean fHasOptionalContent = false;
    private int fNumElements = 0;

    public XSAllCM(boolean bl, int n2) {
        this.fHasOptionalContent = bl;
        this.fAllElements = new XSElementDecl[n2];
        this.fIsOptionalElement = new boolean[n2];
    }

    public void addElement(XSElementDecl xSElementDecl, boolean bl) {
        this.fAllElements[this.fNumElements] = xSElementDecl;
        this.fIsOptionalElement[this.fNumElements] = bl;
        ++this.fNumElements;
    }

    public int[] startContentModel() {
        int[] nArray = new int[this.fNumElements + 1];
        int n2 = 0;
        while (n2 <= this.fNumElements) {
            nArray[n2] = 0;
            ++n2;
        }
        return nArray;
    }

    Object findMatchingDecl(QName qName, SubstitutionGroupHandler substitutionGroupHandler) {
        XSElementDecl xSElementDecl = null;
        int n2 = 0;
        while (n2 < this.fNumElements) {
            xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fAllElements[n2]);
            if (xSElementDecl != null) break;
            ++n2;
        }
        return xSElementDecl;
    }

    public Object oneTransition(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler) {
        if (nArray[0] < 0) {
            nArray[0] = -2;
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        nArray[0] = 1;
        XSElementDecl xSElementDecl = null;
        int n2 = 0;
        while (n2 < this.fNumElements) {
            if (nArray[n2 + 1] == 0 && (xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fAllElements[n2])) != null) {
                nArray[n2 + 1] = 1;
                return xSElementDecl;
            }
            ++n2;
        }
        nArray[0] = -1;
        return this.findMatchingDecl(qName, substitutionGroupHandler);
    }

    public boolean endContentModel(int[] nArray) {
        int n2 = nArray[0];
        if (n2 == -1 || n2 == -2) {
            return false;
        }
        if (this.fHasOptionalContent && n2 == 0) {
            return true;
        }
        int n3 = 0;
        while (n3 < this.fNumElements) {
            if (!this.fIsOptionalElement[n3] && nArray[n3 + 1] == 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        int n2 = 0;
        while (n2 < this.fNumElements) {
            int n3 = n2 + 1;
            while (n3 < this.fNumElements) {
                if (XSConstraints.overlapUPA(this.fAllElements[n2], this.fAllElements[n3], substitutionGroupHandler)) {
                    throw new XMLSchemaException("cos-nonambig", new Object[]{this.fAllElements[n2].toString(), this.fAllElements[n3].toString()});
                }
                ++n3;
            }
            ++n2;
        }
        return false;
    }
}

