/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;

public class OPAQUE
extends DatumWithConnection {
    OpaqueDescriptor descriptor;
    byte[] value;
    long imageOffset;
    long imageLength;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_17:37:29_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OPAQUE(OpaqueDescriptor opaqueDescriptor, Connection connection, Object object) throws SQLException {
        if (opaqueDescriptor != null) {
            this.descriptor = opaqueDescriptor;
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 61, "OPAQUE");
        }
        if (connection != null) {
            this.setPhysicalConnectionOf(connection);
        }
        if (object instanceof byte[]) {
            this.value = (byte[])object;
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59);
        }
    }

    public OPAQUE(OpaqueDescriptor opaqueDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        this.setPhysicalConnectionOf(connection);
        this.descriptor = opaqueDescriptor;
        this.value = null;
    }

    public String getSQLTypeName() throws SQLException {
        return this.descriptor.getName();
    }

    public OpaqueDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    public void setDescriptor(OpaqueDescriptor opaqueDescriptor) {
        this.descriptor = opaqueDescriptor;
    }

    public byte[] toBytes() throws SQLException {
        return this.descriptor.toBytes(this, false);
    }

    public Object getValue() throws SQLException {
        return this.descriptor.toValue(this, false);
    }

    public byte[] getBytesValue() throws SQLException {
        return this.descriptor.toValue(this, false);
    }

    public void setValue(byte[] byArray) throws SQLException {
        this.value = byArray;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new Object[n2];
    }

    public Map getMap() {
        try {
            return this.getInternalConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        Map map = this.getMap();
        return this.toJdbc(map);
    }

    public Object toJdbc(Map map) throws SQLException {
        Class clazz;
        Object object = this;
        if (map != null && (clazz = this.descriptor.getClass(map)) != null) {
            object = this.toClass(clazz, map);
        }
        return object;
    }

    public Object toClass(Class clazz) throws SQLException {
        return this.toClass(clazz, this.getMap());
    }

    public Object toClass(Class clazz, Map map) throws SQLException {
        Object object = null;
        try {
            if (clazz == null || clazz == OPAQUE.class) {
                object = this;
            } else {
                ORAData oRAData = null;
                Object t2 = clazz.newInstance();
                if (t2 instanceof ORADataFactory) {
                    ORADataFactory oRADataFactory = (ORADataFactory)t2;
                    oRAData = oRADataFactory.create(this, 2007);
                } else {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 49, this.descriptor.getName());
                }
                object = oRAData;
            }
        }
        catch (InstantiationException instantiationException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + illegalAccessException.getMessage());
        }
        return object;
    }

    public void setImage(byte[] byArray, long l2, long l3) throws SQLException {
        this.setShareBytes(byArray);
        this.imageOffset = l2;
        this.imageLength = l3;
    }

    public void setImageLength(long l2) throws SQLException {
        this.imageLength = l2;
    }

    public long getImageOffset() {
        return this.imageOffset;
    }

    public long getImageLength() {
        return this.imageLength;
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }
}

