/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4CBfileAccessor;
import oracle.jdbc.driver.T4CBinaryDoubleAccessor;
import oracle.jdbc.driver.T4CBinaryFloatAccessor;
import oracle.jdbc.driver.T4CBlobAccessor;
import oracle.jdbc.driver.T4CCharAccessor;
import oracle.jdbc.driver.T4CClobAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CDateAccessor;
import oracle.jdbc.driver.T4CIntervaldsAccessor;
import oracle.jdbc.driver.T4CIntervalymAccessor;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CLongRawAccessor;
import oracle.jdbc.driver.T4CNamedTypeAccessor;
import oracle.jdbc.driver.T4CNumberAccessor;
import oracle.jdbc.driver.T4COutRawAccessor;
import oracle.jdbc.driver.T4CRawAccessor;
import oracle.jdbc.driver.T4CRefTypeAccessor;
import oracle.jdbc.driver.T4CResultSetAccessor;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTimestampAccessor;
import oracle.jdbc.driver.T4CTimestampltzAccessor;
import oracle.jdbc.driver.T4CTimestamptzAccessor;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.jdbc.driver.T4CVarnumAccessor;

class T4CPreparedStatement
extends OraclePreparedStatement {
    static final byte[] EMPTY_BYTE = new byte[0];
    T4CConnection t4Connection;
    boolean aFetchWasDoneDuringDescribe = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_17:37:41_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T4CPreparedStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        super(physicalConnection, string, physicalConnection.defaultExecuteBatch, physicalConnection.defaultRowPrefetch, n2, n3);
        this.nbPostPonedColumns = new int[1];
        this.nbPostPonedColumns[0] = 0;
        this.indexOfPostPonedColumn = new int[1][3];
        this.t4Connection = (T4CConnection)physicalConnection;
        this.theRowidBinder = theStaticT4CRowidBinder;
        this.theRowidNullBinder = theStaticT4CRowidNullBinder;
    }

    void doOall8(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SQLException, IOException {
        int n2;
        if (bl || bl4 || !bl2 || this.sqlKind != 2 && this.sqlKind != 1 && this.sqlKind != 4) {
            this.oacdefSent = null;
        }
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.doOall8");
        if (this.sqlKind != 1 && this.sqlKind != 4 && this.sqlKind != 3 && this.sqlKind != 0 && this.sqlKind != 2) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 439);
        }
        if (bl3) {
            this.rowPrefetchInLastFetch = this.rowPrefetch;
        }
        int n3 = this.numberOfDefinePositions;
        if (this.sqlKind == 2) {
            n3 = 0;
        }
        if (this.accessors != null) {
            for (n2 = 0; n2 < this.accessors.length; ++n2) {
                if (this.accessors[n2] == null) continue;
                this.accessors[n2].lastRowProcessed = 0;
            }
        }
        if (this.outBindAccessors != null) {
            for (n2 = 0; n2 < this.outBindAccessors.length; ++n2) {
                if (this.outBindAccessors[n2] == null) continue;
                this.outBindAccessors[n2].lastRowProcessed = 0;
            }
        }
        if (this.returnParamAccessors != null) {
            for (n2 = 0; n2 < this.returnParamAccessors.length; ++n2) {
                if (this.returnParamAccessors[n2] == null) continue;
                this.returnParamAccessors[n2].lastRowProcessed = 0;
            }
        }
        if (this.bindIndicators != null) {
            n2 = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
            int n4 = 0;
            if (this.ibtBindChars != null) {
                n4 = this.ibtBindChars.length * this.connection.conversion.cMaxCharSize;
            }
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                int n5 = this.bindIndicatorSubRange + 5 + 10 * i2;
                int n6 = this.bindIndicators[n5 + 2] & 0xFFFF;
                if (n6 == 0) continue;
                int n7 = this.bindIndicators[n5 + 9] & 0xFFFF;
                n4 = n7 == 2 ? Math.max(n6 * this.connection.conversion.maxNCharSize, n4) : Math.max(n6 * this.connection.conversion.cMaxCharSize, n4);
            }
            if (this.tmpBindsByteArray == null) {
                this.tmpBindsByteArray = new byte[n4];
            } else if (this.tmpBindsByteArray.length < n4) {
                this.tmpBindsByteArray = null;
                this.tmpBindsByteArray = new byte[n4];
            }
        } else {
            this.tmpBindsByteArray = null;
        }
        this.allocateTmpByteArray();
        T4C8Oall t4C8Oall = this.t4Connection.all8;
        this.t4Connection.sendPiggyBackedMessages();
        this.oacdefSent = t4C8Oall.marshal(bl, bl2, bl3, bl4, this.sqlKind, this.cursorId, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals), this.rowPrefetch, this.outBindAccessors, this.numberOfBindPositions, this.accessors, n3, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.connection.conversion, this.tmpBindsByteArray, this.parameterStream, this.parameterDatum, this.parameterOtype, this, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, this.oacdefSent, this.definedColumnType, this.definedColumnSize, this.definedColumnFormOfUse, this.registration);
        try {
            t4C8Oall.receive();
            this.cursorId = t4C8Oall.getCursorId();
        }
        catch (SQLException sQLException) {
            this.cursorId = t4C8Oall.getCursorId();
            if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw sQLException;
        }
    }

    @Override
    void allocateTmpByteArray() {
        if (this.tmpByteArray == null) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        } else if (this.sizeTmpByteArray > this.tmpByteArray.length) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        }
    }

    @Override
    void releaseBuffers() {
        super.releaseBuffers();
        this.tmpByteArray = null;
        this.tmpBindsByteArray = null;
        this.t4Connection.all8.bindChars = null;
        this.t4Connection.all8.bindBytes = null;
        this.t4Connection.all8.tmpBindsByteArray = null;
    }

    @Override
    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new T4CRowidAccessor(this, 128, 1, -8, false, this.t4Connection.mare);
    }

    @Override
    void reparseOnRedefineIfNeeded() throws SQLException {
        this.needToParse = true;
    }

    @Override
    protected void defineColumnTypeInternal(int n2, int n3, int n4, short s2, boolean bl, String string) throws SQLException {
        int[] nArray;
        if (this.connection.disableDefinecolumntype) {
            return;
        }
        if (n2 < 1) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
        }
        if (bl) {
            if (n3 == 1 || n3 == 12) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 108);
            }
        } else if (n4 < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 53);
        }
        if (this.currentResultSet != null && !this.currentResultSet.closed) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 28);
        }
        int n5 = n2 - 1;
        if (this.definedColumnType == null || this.definedColumnType.length <= n5) {
            if (this.definedColumnType == null) {
                this.definedColumnType = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnType, 0, nArray, 0, this.definedColumnType.length);
                this.definedColumnType = nArray;
            }
        }
        this.definedColumnType[n5] = n3;
        if (this.definedColumnSize == null || this.definedColumnSize.length <= n5) {
            if (this.definedColumnSize == null) {
                this.definedColumnSize = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnSize, 0, nArray, 0, this.definedColumnSize.length);
                this.definedColumnSize = nArray;
            }
        }
        this.definedColumnSize[n5] = n4;
        if (this.definedColumnFormOfUse == null || this.definedColumnFormOfUse.length <= n5) {
            if (this.definedColumnFormOfUse == null) {
                this.definedColumnFormOfUse = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnFormOfUse, 0, nArray, 0, this.definedColumnFormOfUse.length);
                this.definedColumnFormOfUse = nArray;
            }
        }
        this.definedColumnFormOfUse[n5] = s2;
        if (this.accessors != null && n5 < this.accessors.length && this.accessors[n5] != null) {
            this.accessors[n5].definedColumnSize = n4;
            if (!(this.accessors[n5].internalType != 96 && this.accessors[n5].internalType != 1 || n3 != 1 && n3 != 12 || n4 > this.accessors[n5].oacmxl)) {
                this.needToPrepareDefineBuffer = true;
                this.columnsDefinedByUser = true;
                this.accessors[n5].initForDataAccess(n3, n4, null);
                this.accessors[n5].calculateSizeTmpByteArray();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDefines() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            super.clearDefines();
            this.definedColumnType = null;
            this.definedColumnSize = null;
            this.definedColumnFormOfUse = null;
        }
    }

    @Override
    void saveDefineBuffersIfRequired(char[] cArray, byte[] byArray, short[] sArray, boolean bl) throws SQLException {
        int n2;
        if (bl) {
            sArray = new short[this.defineIndicators.length];
            n2 = this.accessors[0].lengthIndexLastRow;
            int n3 = this.accessors[0].indicatorIndexLastRow;
            for (int i2 = 1; i2 <= this.accessors.length; ++i2) {
                int n4 = n2 + this.rowPrefetchInLastFetch * i2 - 1;
                int n5 = n3 + this.rowPrefetchInLastFetch * i2 - 1;
                sArray[n5] = this.defineIndicators[n5];
                sArray[n4] = this.defineIndicators[n4];
            }
        }
        for (n2 = 0; n2 < this.accessors.length; ++n2) {
            this.accessors[n2].saveDataFromOldDefineBuffers(byArray, cArray, sArray, this.rowPrefetchInLastFetch != -1 ? this.rowPrefetchInLastFetch : this.rowPrefetch, this.rowPrefetch);
        }
    }

    @Override
    Accessor allocateAccessor(int n2, int n3, int n4, int n5, short s2, String string, boolean bl) throws SQLException {
        Accessor accessor = null;
        switch (n2) {
            case 96: {
                accessor = new T4CCharAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 8: {
                if (!bl) {
                    accessor = new T4CLongAccessor(this, n4, n5, s2, n3, this.t4Connection.mare);
                    break;
                }
            }
            case 1: {
                accessor = new T4CVarcharAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 2: {
                accessor = new T4CNumberAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 6: {
                accessor = new T4CVarnumAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 24: {
                if (!bl) {
                    accessor = new T4CLongRawAccessor(this, n4, n5, s2, n3, this.t4Connection.mare);
                    break;
                }
            }
            case 23: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                }
                if (bl) {
                    accessor = new T4COutRawAccessor(this, n5, s2, n3, this.t4Connection.mare);
                    break;
                }
                accessor = new T4CRawAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 100: {
                accessor = new T4CBinaryFloatAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 101: {
                accessor = new T4CBinaryDoubleAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 104: {
                if (this.sqlKind == 4) {
                    accessor = new T4CVarcharAccessor(this, 18, s2, n3, bl, this.t4Connection.mare);
                    accessor.definedColumnType = -8;
                    break;
                }
                accessor = new T4CRowidAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 102: {
                accessor = new T4CResultSetAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 12: {
                accessor = new T4CDateAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 113: {
                accessor = new T4CBlobAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 112: {
                accessor = new T4CClobAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 114: {
                accessor = new T4CBfileAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 109: {
                accessor = new T4CNamedTypeAccessor(this, string, s2, n3, bl, this.t4Connection.mare);
                accessor.initMetadata();
                break;
            }
            case 111: {
                accessor = new T4CRefTypeAccessor(this, string, s2, n3, bl, this.t4Connection.mare);
                accessor.initMetadata();
                break;
            }
            case 180: {
                accessor = new T4CTimestampAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 181: {
                accessor = new T4CTimestamptzAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 231: {
                accessor = new T4CTimestampltzAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 182: {
                accessor = new T4CIntervalymAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 183: {
                accessor = new T4CIntervaldsAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 995: {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 89);
            }
        }
        return accessor;
    }

    @Override
    void doDescribe(boolean bl) throws SQLException {
        if (!this.isOpen) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 144);
        }
        try {
            this.t4Connection.needLine();
            this.t4Connection.sendPiggyBackedMessages();
            this.t4Connection.describe.init(this, 0);
            this.t4Connection.describe.marshal();
            this.accessors = this.t4Connection.describe.receive(this.accessors);
            this.numberOfDefinePositions = this.t4Connection.describe.numuds;
            for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                this.accessors[i2].initMetadata();
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        this.describedWithNames = true;
        this.described = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeForDescribe() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.execute_for_describe");
        this.cleanOldTempLobs();
        try {
            if (this.t4Connection.useFetchSizeWithLongColumn) {
                this.doOall8(true, true, true, true);
            } else {
                this.doOall8(true, true, false, true);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        finally {
            this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
            this.validRows = this.t4Connection.all8.getNumRows();
        }
        this.needToParse = false;
        this.aFetchWasDoneDuringDescribe = false;
        if (this.t4Connection.all8.aFetchWasDone) {
            this.aFetchWasDoneDuringDescribe = true;
            this.rowPrefetchInLastFetch = this.rowPrefetch;
        }
        for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
            this.accessors[i2].initMetadata();
        }
        this.needToPrepareDefineBuffer = false;
    }

    @Override
    void executeMaybeDescribe() throws SQLException {
        boolean bl = true;
        if (this.rowPrefetchChanged) {
            if (this.streamList == null && this.rowPrefetch != this.definesBatchSize) {
                this.needToPrepareDefineBuffer = true;
            }
            this.rowPrefetchChanged = false;
        }
        if (!this.needToPrepareDefineBuffer) {
            if (this.accessors == null) {
                this.needToPrepareDefineBuffer = true;
            } else if (this.columnsDefinedByUser) {
                this.needToPrepareDefineBuffer = !this.checkAccessorsUsable();
            }
        }
        boolean bl2 = false;
        try {
            this.isExecuting = true;
            if (this.needToPrepareDefineBuffer) {
                if (!this.columnsDefinedByUser) {
                    this.executeForDescribe();
                    bl2 = true;
                    if (this.aFetchWasDoneDuringDescribe) {
                        bl = false;
                    }
                } else {
                    this.prepareAccessors();
                }
            }
            int n2 = this.accessors.length;
            for (int i2 = this.numberOfDefinePositions; i2 < n2; ++i2) {
                Accessor accessor = this.accessors[i2];
                if (accessor == null) continue;
                accessor.rowSpaceIndicator = null;
            }
            if (bl) {
                this.executeForRows(bl2);
            }
        }
        catch (SQLException sQLException) {
            this.needToParse = true;
            throw sQLException;
        }
        finally {
            this.isExecuting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeForRows(boolean bl) throws SQLException {
        try {
            try {
                if (this.columnsDefinedByUser && this.needToPrepareDefineBuffer) {
                    this.needToPrepareDefineBuffer = false;
                }
                this.doOall8(this.needToParse, !bl, true, false);
                this.needToParse = false;
            }
            finally {
                this.validRows = this.t4Connection.all8.getNumRows();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    void fetch() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
        try {
            this.doOall8(false, false, true, false);
            this.validRows = this.t4Connection.all8.getNumRows();
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
    }

    @Override
    void continueReadRow(int n2) throws SQLException {
        try {
            if (!this.connection.useFetchSizeWithLongColumn) {
                T4C8Oall t4C8Oall = this.t4Connection.all8;
                t4C8Oall.continueReadRow(n2);
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw sQLException;
        }
    }

    @Override
    void doClose() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.do_close");
        try {
            if (this.cursorId != 0) {
                this.t4Connection.cursorToClose[this.t4Connection.cursorToCloseOffset++] = this.cursorId;
                if (this.t4Connection.cursorToCloseOffset >= this.t4Connection.cursorToClose.length) {
                    this.t4Connection.sendPiggyBackedMessages();
                }
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        this.tmpByteArray = null;
        this.tmpBindsByteArray = null;
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        this.oacdefSent = null;
    }

    @Override
    void closeQuery() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.closeQuery");
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    @Override
    Binder getRowidNullBinder(int n2) {
        if (this.sqlKind == 4) {
            this.currentRowCharLens[n2] = 1;
            return this.theVarcharNullBinder;
        }
        return this.theRowidNullBinder;
    }

    @Override
    void doLocalInitialization() {
        super.doLocalInitialization();
        this.t4Connection.all8.bindChars = this.bindChars;
        this.t4Connection.all8.bindBytes = this.bindBytes;
    }
}

