/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import com.vmware.vim25.ws.Argument;
import com.vmware.vim25.ws.XmlGen;
import com.vmware.vim25.ws.XmlGenDom;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.BindException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class WSClient {
    private static final String VMWARE_DEBUG_PROP = "com.ahsay.afc.vmware.debug";
    private static final boolean VM_DEBUG = "true".equalsIgnoreCase(System.getProperty("com.ahsay.afc.vmware.debug"));
    private static final String SOAP_ACTION_HEADER = "SOAPAction";
    private static final String SOAP_ACTION_V40 = "urn:vim25/4.0";
    private static final String SOAP_ACTION_V41 = "urn:vim25/4.1";
    private static final String SOAP_ACTION_V50 = "urn:vim25/5.0";
    private static final String SOAP_ACTION_V51 = "urn:vim25/5.1";
    private static final String SOAP_ACTION_V55 = "urn:vim25/5.5";
    private URL baseUrl = null;
    private String cookie = null;
    private String vimNameSpace = null;
    private String soapAction = null;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    XmlGen xmlGen = new XmlGenDom();

    public WSClient(String serverUrl) throws MalformedURLException {
        this(serverUrl, true);
    }

    public WSClient(String serverUrl, boolean ignoreCert) throws MalformedURLException {
        if (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        this.baseUrl = new URL(serverUrl);
        if (ignoreCert) {
            try {
                WSClient.trustAllHttpsCertificates();
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String urlHostName, SSLSession session) {
                        return true;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String methodName, Argument[] paras, String returnType) throws RemoteException {
        String soapMsg = XmlGen.toXML(methodName, paras, this.vimNameSpace);
        int iRetryDelay = 1;
        while (true) {
            Object object;
            HttpURLConnection postCon;
            block20: {
                if (VM_DEBUG) {
                    System.out.println("[WSClient.invoke] Open connection " + this.baseUrl.getPath());
                }
                postCon = (HttpURLConnection)this.baseUrl.openConnection();
                if (VM_DEBUG) {
                    System.out.println("[WSClient.invoke] post SOAP Message" + soapMsg);
                }
                InputStream is = this.post(postCon, soapMsg);
                try {
                    object = this.xmlGen.fromXML(returnType, is);
                    if (is == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (is != null) {
                                is.close();
                            }
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (postCon != null) {
                                postCon.disconnect();
                            }
                            throw throwable2;
                        }
                    }
                    catch (Exception e1) {
                        if (!(e1 instanceof BindException) || iRetryDelay >= 240) {
                            if (e1 instanceof RemoteException) {
                                throw (RemoteException)e1;
                            }
                            throw new RemoteException("VI SDK invoke exception:" + e1);
                        }
                        if (VM_DEBUG) {
                            System.out.println("[WSClient.invoke] Exception" + e1.getMessage());
                        }
                        iRetryDelay *= 2;
                        if (VM_DEBUG) {
                            System.out.println("[WSClient.invoke] Sleep" + iRetryDelay + " seconds");
                        }
                        try {
                            Thread.sleep(iRetryDelay * 1000);
                        }
                        catch (Throwable t2) {}
                        {
                        }
                        continue;
                    }
                }
                is.close();
            }
            if (postCon != null) {
                postCon.disconnect();
            }
            return object;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public StringBuffer invokeAsString(String methodName, Argument[] paras) throws RemoteException {
        String soapMsg = XmlGen.toXML(methodName, paras, this.vimNameSpace);
        try {
            HttpURLConnection postCon = (HttpURLConnection)this.baseUrl.openConnection();
            try {
                StringBuffer stringBuffer;
                block10: {
                    InputStream is = this.post(postCon, soapMsg);
                    try {
                        stringBuffer = this.readStream(is);
                        if (is == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            is.close();
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return stringBuffer;
            }
            finally {
                if (postCon != null) {
                    postCon.disconnect();
                }
            }
        }
        catch (Exception e2) {
            throw new RemoteException("VI SDK invoke exception:" + e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream post(HttpURLConnection postCon, String soapMsg) throws IOException {
        InputStream is;
        if (VM_DEBUG) {
            System.out.println("[WSClient.post] Start");
        }
        if (this.connectTimeout > 0) {
            postCon.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout > 0) {
            postCon.setReadTimeout(this.readTimeout);
        }
        postCon.setRequestMethod("POST");
        postCon.setDoOutput(true);
        postCon.setDoInput(true);
        postCon.setRequestProperty(SOAP_ACTION_HEADER, this.soapAction);
        postCon.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
        byte[] abBytes = soapMsg.getBytes("UTF-8");
        postCon.setRequestProperty("Content-Length", String.valueOf(abBytes.length));
        if (this.cookie != null) {
            postCon.setRequestProperty("Cookie", this.cookie);
        }
        if (VM_DEBUG) {
            System.out.println("[WSClient.post] Connect, cookie=" + this.cookie);
        }
        postCon.connect();
        int BUFFER_SIZE = 16384;
        BufferedOutputStream os = new BufferedOutputStream(postCon.getOutputStream(), 16384);
        try {
            ((OutputStream)os).write(abBytes);
        }
        finally {
            ((OutputStream)os).close();
        }
        if (VM_DEBUG) {
            System.out.println("[WSClient.post] GetInputStream");
        }
        try {
            is = postCon.getInputStream();
        }
        catch (IOException ioe) {
            ByteArrayOutputStream baos;
            is = postCon.getErrorStream();
            try {
                baos = new ByteArrayOutputStream(16384);
                try {
                    int iRead;
                    byte[] abData = new byte[16384];
                    while ((iRead = is.read(abData)) != -1) {
                        System.out.write(abData, 0, iRead);
                        baos.write(abData, 0, iRead);
                    }
                }
                finally {
                    baos.close();
                }
            }
            finally {
                is.close();
            }
            is = new ByteArrayInputStream(baos.toByteArray());
        }
        is = new BufferedInputStream(is, 16384);
        if (this.cookie == null) {
            this.cookie = postCon.getHeaderField("Set-Cookie");
        }
        if (VM_DEBUG) {
            System.out.println("[WSClient.post] End");
        }
        return is;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public String getVimNameSpace() {
        return this.vimNameSpace;
    }

    public void setVimNameSpace(String vimNameSpace) {
        this.vimNameSpace = vimNameSpace;
    }

    public void setConnectTimeout(int timeoutMilliSec) {
        this.connectTimeout = timeoutMilliSec;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int timeoutMilliSec) {
        this.readTimeout = timeoutMilliSec;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setSoapActionOnApiVersion(String apiVersion) {
        this.soapAction = "4.0".equals(apiVersion) ? SOAP_ACTION_V40 : ("4.1".equals(apiVersion) ? SOAP_ACTION_V41 : ("5.0".equals(apiVersion) ? SOAP_ACTION_V50 : ("5.1".equals(apiVersion) ? SOAP_ACTION_V51 : ("5.5".equals(apiVersion) ? SOAP_ACTION_V55 : SOAP_ACTION_V55))));
    }

    private StringBuffer readStream(InputStream is) throws IOException {
        String lineStr;
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        while ((lineStr = in.readLine()) != null) {
            sb.append(lineStr);
        }
        return sb;
    }

    private static void trustAllHttpsCertificates() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new TrustAllManager()};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private TrustAllManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

