/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.LocalizableMessage;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MethodFault;
import com.vmware.vim25.OutOfBounds;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInfo;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.mo.ExtensibleManagedObject;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServerConnection;
import java.rmi.RemoteException;

public class Task
extends ExtensibleManagedObject {
    public static final String PROPNAME_INFO = "info";
    public static final String SUCCESS = "success";

    public Task(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public TaskInfo getTaskInfo() throws InvalidProperty, RuntimeFault, RemoteException {
        return (TaskInfo)this.getCurrentProperty(PROPNAME_INFO);
    }

    public ManagedEntity getAssociatedManagedEntity() {
        return (ManagedEntity)this.getManagedObject("info.entity");
    }

    public ManagedEntity[] getLockedManagedEntities() {
        return (ManagedEntity[])this.getManagedObjects("info.locked");
    }

    public void cancelTask() throws RuntimeFault, RemoteException {
        this.getVimService().cancelTask(this.getMOR());
    }

    public void setTaskState(TaskInfoState tis, Object result, LocalizedMethodFault fault) throws InvalidState, RuntimeFault, RemoteException {
        this.getVimService().setTaskState(this.getMOR(), tis, result, fault);
    }

    public void updateProgress(int percentDone) throws InvalidState, OutOfBounds, RuntimeFault, RemoteException {
        this.getVimService().updateProgress(this.getMOR(), percentDone);
    }

    public void setTaskDescription(LocalizableMessage description) throws RuntimeFault, RemoteException {
        this.getVimService().setTaskDescription(this.getMOR(), description);
    }

    public String waitForMe() throws InvalidProperty, RuntimeFault, RemoteException {
        Object[] result = this.waitForValues(new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.success, TaskInfoState.error}});
        if (result[0].equals((Object)TaskInfoState.success)) {
            return SUCCESS;
        }
        TaskInfo tinfo = (TaskInfo)this.getCurrentProperty(PROPNAME_INFO);
        LocalizedMethodFault fault = tinfo.getError();
        String error = "Error Occured";
        if (fault != null) {
            MethodFault mf = fault.getFault();
            throw mf;
        }
        return error;
    }

    public String waitForTask() throws RuntimeFault, RemoteException, InterruptedException {
        return this.waitForTask(500, 1000);
    }

    public String waitForTask(int runningDelayInMillSecond, int queuedDelayInMillSecond) throws RuntimeFault, RemoteException, InterruptedException {
        Enum tState = null;
        int tries = 0;
        int maxTries = 3;
        Exception getInfoException = null;
        while (tState == null || tState.equals((Object)TaskInfoState.running) || tState.equals((Object)TaskInfoState.queued)) {
            tState = null;
            getInfoException = null;
            tries = 0;
            while (tState == null) {
                if (++tries > maxTries) {
                    if (getInfoException == null) {
                        throw new NullPointerException();
                    }
                    if (getInfoException instanceof RuntimeFault) {
                        throw (RuntimeFault)getInfoException;
                    }
                    if (getInfoException instanceof RemoteException) {
                        throw (RemoteException)getInfoException;
                    }
                    throw new RuntimeException(getInfoException);
                }
                try {
                    tState = this.getTaskInfo().getState();
                }
                catch (Exception e2) {
                    getInfoException = e2;
                }
            }
            if (tState.equals((Object)TaskInfoState.running)) {
                Thread.sleep(runningDelayInMillSecond);
                continue;
            }
            Thread.sleep(queuedDelayInMillSecond);
        }
        return tState.toString();
    }
}

