/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.UserSession;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.ws.WSClient;
import java.net.URL;

public final class ServerConnection {
    private URL url = null;
    private UserSession userSession = null;
    private ServiceInstance serviceInstance = null;
    private VimPortType vimService = null;

    public ServerConnection(URL url, VimPortType vimService, ServiceInstance serviceInstance) {
        this.url = url;
        this.vimService = vimService;
        this.serviceInstance = serviceInstance;
    }

    public String getSessionStr() {
        WSClient wsc = this.vimService.getWsc();
        return wsc.getCookie();
    }

    public void logout() {
        if (this.vimService != null) {
            try {
                this.serviceInstance.getSessionManager().logout();
            }
            catch (Exception e2) {
                System.err.println("Failed to disconnect...");
            }
            this.vimService = null;
            this.serviceInstance = null;
        }
    }

    public ServiceInstance getServiceInstance() {
        return this.serviceInstance;
    }

    public VimPortType getVimService() {
        return this.vimService;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.userSession.getUserName();
    }

    public UserSession getUserSession() {
        return this.userSession;
    }

    void setUserSession(UserSession userSession) {
        this.userSession = userSession;
    }

    void setServiceInstance(ServiceInstance si) {
        this.serviceInstance = si;
    }
}

