/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.DuplicateName;
import com.vmware.vim25.InvalidName;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.ScheduledTaskDescription;
import com.vmware.vim25.ScheduledTaskSpec;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ScheduledTask;
import com.vmware.vim25.mo.ServerConnection;
import java.rmi.RemoteException;

public class ScheduledTaskManager
extends ManagedObject {
    public ScheduledTaskManager(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public ScheduledTaskDescription getDescriptioin() {
        return (ScheduledTaskDescription)this.getCurrentProperty("description");
    }

    public ScheduledTask[] getScheduledTasks() {
        return this.getScheduledTasks("scheduledTask");
    }

    public ScheduledTask createScheduledTask(ManagedEntity entity, ScheduledTaskSpec spec) throws InvalidName, DuplicateName, RuntimeFault, RemoteException {
        if (entity == null) {
            throw new IllegalArgumentException("entity must not be null.");
        }
        return new ScheduledTask(this.getServerConnection(), this.getVimService().createScheduledTask(this.getMOR(), entity.getMOR(), spec));
    }

    public ScheduledTask createObjectScheduledTask(ManagedObject obj, ScheduledTaskSpec spec) throws InvalidName, DuplicateName, RuntimeFault, RemoteException {
        if (obj == null) {
            throw new IllegalArgumentException("managed object must not be null.");
        }
        return new ScheduledTask(this.getServerConnection(), this.getVimService().createObjectScheduledTask(this.getMOR(), obj.getMOR(), spec));
    }

    public ScheduledTask[] retrieveEntityScheduledTask(ManagedEntity entity) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = this.getVimService().retrieveEntityScheduledTask(this.getMOR(), entity == null ? null : entity.getMOR());
        ScheduledTask[] tasks = new ScheduledTask[mors.length];
        for (int i2 = 0; i2 < mors.length; ++i2) {
            tasks[i2] = new ScheduledTask(this.getServerConnection(), mors[i2]);
        }
        return tasks;
    }

    public ScheduledTask[] retrieveObjectScheduledTask(ManagedObject obj) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = this.getVimService().retrieveObjectScheduledTask(this.getMOR(), obj == null ? null : obj.getMOR());
        ScheduledTask[] tasks = new ScheduledTask[mors.length];
        for (int i2 = 0; i2 < mors.length; ++i2) {
            tasks[i2] = new ScheduledTask(this.getServerConnection(), mors[i2]);
        }
        return tasks;
    }
}

