/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.AlreadyExists;
import com.vmware.vim25.DuplicateName;
import com.vmware.vim25.FcoeConfigFcoeSpecification;
import com.vmware.vim25.FcoeFaultPnicHasNoPortSet;
import com.vmware.vim25.HostConfigFault;
import com.vmware.vim25.HostDiskPartitionBlockRange;
import com.vmware.vim25.HostDiskPartitionInfo;
import com.vmware.vim25.HostDiskPartitionLayout;
import com.vmware.vim25.HostDiskPartitionSpec;
import com.vmware.vim25.HostFileSystemVolumeInfo;
import com.vmware.vim25.HostInternetScsiHbaAuthenticationProperties;
import com.vmware.vim25.HostInternetScsiHbaDigestProperties;
import com.vmware.vim25.HostInternetScsiHbaDiscoveryProperties;
import com.vmware.vim25.HostInternetScsiHbaIPProperties;
import com.vmware.vim25.HostInternetScsiHbaParamValue;
import com.vmware.vim25.HostInternetScsiHbaSendTarget;
import com.vmware.vim25.HostInternetScsiHbaStaticTarget;
import com.vmware.vim25.HostInternetScsiHbaTargetSet;
import com.vmware.vim25.HostMultipathInfoLogicalUnitPolicy;
import com.vmware.vim25.HostMultipathStateInfo;
import com.vmware.vim25.HostPathSelectionPolicyOption;
import com.vmware.vim25.HostScsiDisk;
import com.vmware.vim25.HostScsiDiskPartition;
import com.vmware.vim25.HostStorageArrayTypePolicyOption;
import com.vmware.vim25.HostStorageDeviceInfo;
import com.vmware.vim25.HostUnresolvedVmfsResolutionResult;
import com.vmware.vim25.HostUnresolvedVmfsResolutionSpec;
import com.vmware.vim25.HostUnresolvedVmfsVolume;
import com.vmware.vim25.HostVffsSpec;
import com.vmware.vim25.HostVmfsSpec;
import com.vmware.vim25.HostVmfsVolume;
import com.vmware.vim25.InvalidName;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.ResourceInUse;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.ExtensibleManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import java.rmi.RemoteException;

public class HostStorageSystem
extends ExtensibleManagedObject {
    public HostStorageSystem(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public HostFileSystemVolumeInfo getFileSystemVolumeInfo() {
        return (HostFileSystemVolumeInfo)this.getCurrentProperty("fileSystemVolumeInfo");
    }

    public HostMultipathStateInfo getMultipathStateInfo() {
        return (HostMultipathStateInfo)this.getCurrentProperty("multipathStateInfo");
    }

    public HostStorageDeviceInfo getStorageDeviceInfo() {
        return (HostStorageDeviceInfo)this.getCurrentProperty("storageDeviceInfo");
    }

    public String[] getSystemFile() {
        return (String[])this.getCurrentProperty("systemFile");
    }

    public void addInternetScsiSendTargets(String iScsiHbaDevice, HostInternetScsiHbaSendTarget[] targets) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().addInternetScsiSendTargets(this.getMOR(), iScsiHbaDevice, targets);
    }

    public void addInternetScsiStaticTargets(String iScsiHbaDevice, HostInternetScsiHbaStaticTarget[] targets) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().addInternetScsiStaticTargets(this.getMOR(), iScsiHbaDevice, targets);
    }

    public void attachScsiLun(String lunUuid) throws NotFound, HostConfigFault, InvalidState, RuntimeFault, RemoteException {
        this.getVimService().attachScsiLun(this.getMOR(), lunUuid);
    }

    public void attachVmfsExtent(String vmfsPath, HostScsiDiskPartition extent) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().attachVmfsExtent(this.getMOR(), vmfsPath, extent);
    }

    public HostDiskPartitionInfo computeDiskPartitionInfo(String devicePath, HostDiskPartitionLayout layout) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        return this.computeDiskPartitionInfo(devicePath, layout, null);
    }

    public HostDiskPartitionInfo computeDiskPartitionInfo(String devicePath, HostDiskPartitionLayout layout, String partitionFormat) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        return this.getVimService().computeDiskPartitionInfo(this.getMOR(), devicePath, layout, partitionFormat);
    }

    public HostDiskPartitionInfo computeDiskPartitionInfoForResize(HostScsiDiskPartition partition, HostDiskPartitionBlockRange blockRange) throws NotFound, HostConfigFault, RuntimeFault, RemoteException {
        return this.computeDiskPartitionInfoForResize(partition, blockRange, null);
    }

    public HostDiskPartitionInfo computeDiskPartitionInfoForResize(HostScsiDiskPartition partition, HostDiskPartitionBlockRange blockRange, String partitionFormat) throws NotFound, HostConfigFault, RuntimeFault, RemoteException {
        return this.getVimService().computeDiskPartitionInfoForResize(this.getMOR(), partition, blockRange, partitionFormat);
    }

    public void deleteVffsVolumeState(String vffsUuid) throws HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().deleteVffsVolumeState(this.getMOR(), vffsUuid);
    }

    public void destroyVffs(String vffsPath) throws NotFound, HostConfigFault, ResourceInUse, RuntimeFault, RemoteException {
        this.getVimService().destroyVffs(this.getMOR(), vffsPath);
    }

    public void detachScsiLun(String lunUuid) throws NotFound, HostConfigFault, InvalidState, ResourceInUse, RuntimeFault, RemoteException {
        this.getVimService().detachScsiLun(this.getMOR(), lunUuid);
    }

    public void disableMultipathPath(String pathName) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().disableMultipathPath(this.getMOR(), pathName);
    }

    public void discoverFcoeHbas(FcoeConfigFcoeSpecification fcoeSpec) throws FcoeFaultPnicHasNoPortSet, HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().discoverFcoeHbas(this.getMOR(), fcoeSpec);
    }

    public void enableMultipathPath(String pathName) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().enableMultipathPath(this.getMOR(), pathName);
    }

    public void expandVmfsExtent(String vmfsPath, HostScsiDiskPartition extent) throws NotFound, HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().expandVmfsExtent(this.getMOR(), vmfsPath, extent);
    }

    public void extendVffs(String vffsPath, String devicePath, HostDiskPartitionSpec spec) throws NotFound, HostConfigFault, ResourceInUse, RuntimeFault, RemoteException {
        this.getVimService().extendVffs(this.getMOR(), vffsPath, devicePath, spec);
    }

    public void formatVffs(String vffsPath, String devicePath, HostVffsSpec createSpec) throws AlreadyExists, HostConfigFault, ResourceInUse, RuntimeFault, RemoteException {
        this.getVimService().formatVffs(this.getMOR(), createSpec);
    }

    public HostVmfsVolume formatVmfs(HostVmfsSpec createSpec) throws HostConfigFault, AlreadyExists, RuntimeFault, RemoteException {
        return this.getVimService().formatVmfs(this.getMOR(), createSpec);
    }

    public void markForRemoval(String hbaName, boolean remove) throws NotFound, HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().markForRemoval(this.getMOR(), hbaName, remove);
    }

    public void mountVffsVolume(String vffsUuid) throws NotFound, InvalidState, HostConfigFault, ResourceInUse, RuntimeFault, RemoteException {
        this.getVimService().mountVffsVolume(this.getMOR(), vffsUuid);
    }

    public void mountVmfsVolume(String vmfsUuid) throws NotFound, InvalidState, HostConfigFault, ResourceInUse, RuntimeFault, RemoteException {
        this.getVimService().mountVmfsVolume(this.getMOR(), vmfsUuid);
    }

    public HostScsiDisk[] queryAvailableSsds(String vffsPath) throws NotFound, HostConfigFault, RuntimeFault, RemoteException {
        return this.getVimService().queryAvailableSsds(this.getMOR(), vffsPath);
    }

    public HostPathSelectionPolicyOption[] queryPathSelectionPolicyOptions() throws HostConfigFault, RuntimeFault, RemoteException {
        return this.getVimService().queryPathSelectionPolicyOptions(this.getMOR());
    }

    public HostStorageArrayTypePolicyOption[] queryStorageArrayTypePolicyOptions() throws HostConfigFault, RuntimeFault, RemoteException {
        return this.getVimService().queryStorageArrayTypePolicyOptions(this.getMOR());
    }

    public HostUnresolvedVmfsVolume[] queryUnresolvedVmfsVolume() throws RuntimeFault, RemoteException {
        return this.getVimService().queryUnresolvedVmfsVolume(this.getMOR());
    }

    public void refreshStorageSystem() throws RuntimeFault, RemoteException {
        this.getVimService().refreshStorageSystem(this.getMOR());
    }

    public void removeInternetScsiSendTargets(String iScsiHbaDevice, HostInternetScsiHbaSendTarget[] targets) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().removeInternetScsiSendTargets(this.getMOR(), iScsiHbaDevice, targets);
    }

    public void removeInternetScsiStaticTargets(String iScsiHbaDevice, HostInternetScsiHbaStaticTarget[] targets) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().removeInternetScsiStaticTargets(this.getMOR(), iScsiHbaDevice, targets);
    }

    public void rescanAllHba() throws HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().rescanAllHba(this.getMOR());
    }

    public void rescanHba(String hbaDevice) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().rescanHba(this.getMOR(), hbaDevice);
    }

    public void rescanVffs() throws HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().rescanVffs(this.getMOR());
    }

    public void rescanVmfs() throws HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().rescanVmfs(this.getMOR());
    }

    public HostUnresolvedVmfsResolutionResult[] resolveMultipleUnresolvedVmfsVolumes(HostUnresolvedVmfsResolutionSpec[] resolutionSpec) throws HostConfigFault, RuntimeFault, RemoteException {
        return this.getVimService().resolveMultipleUnresolvedVmfsVolumes(this.getMOR(), resolutionSpec);
    }

    public Task resolveMultipleUnresolvedVmfsVolumesEx_Task(HostUnresolvedVmfsResolutionSpec[] resolutionSpec) throws HostConfigFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().resolveMultipleUnresolvedVmfsVolumesEx_Task(this.getMOR(), resolutionSpec);
        return new Task(this.getServerConnection(), mor);
    }

    public HostDiskPartitionInfo[] retrieveDiskPartitionInfo(String[] devicePath) throws RuntimeFault, RemoteException {
        return this.getVimService().retrieveDiskPartitionInfo(this.getMOR(), devicePath);
    }

    public void setMultipathLunPolicy(String lunId, HostMultipathInfoLogicalUnitPolicy policy) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().setMultipathLunPolicy(this.getMOR(), lunId, policy);
    }

    public void unmountForceMountedVmfsVolume(String vmfsUuid) throws NotFound, HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().unmountForceMountedVmfsVolume(this.getMOR(), vmfsUuid);
    }

    public void unmountVffsVolume(String vffsUuid) throws NotFound, InvalidState, HostConfigFault, ResourceInUse, RuntimeFault, RemoteException {
        this.getVimService().unmountVffsVolume(this.getMOR(), vffsUuid);
    }

    public void unmountVmfsVolume(String vmfsUuid) throws NotFound, InvalidState, HostConfigFault, ResourceInUse, RuntimeFault, RemoteException {
        this.getVimService().unmountVmfsVolume(this.getMOR(), vmfsUuid);
    }

    public void updateDiskPartitions(String devicePath, HostDiskPartitionSpec spec) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().updateDiskPartitions(this.getMOR(), devicePath, spec);
    }

    public void updateInternetScsiAlias(String iScsiHbaDevice, String iScsiAlias) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().updateInternetScsiAlias(this.getMOR(), iScsiHbaDevice, iScsiAlias);
    }

    public void updateInternetScsiAuthenticationProperties(String iScsiHbaDevice, HostInternetScsiHbaAuthenticationProperties authenticationProperties) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.updateInternetScsiAuthenticationProperties(iScsiHbaDevice, authenticationProperties, null);
    }

    public void updateInternetScsiAuthenticationProperties(String iScsiHbaDevice, HostInternetScsiHbaAuthenticationProperties authenticationProperties, HostInternetScsiHbaTargetSet targetSet) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().updateInternetScsiAuthenticationProperties(this.getMOR(), iScsiHbaDevice, authenticationProperties, targetSet);
    }

    public void updateInternetScsiAdvancedOptions(String iScsiHbaDevice, HostInternetScsiHbaTargetSet targetSet, HostInternetScsiHbaParamValue[] options) throws NotFound, HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().updateInternetScsiAdvancedOptions(this.getMOR(), iScsiHbaDevice, targetSet, options);
    }

    public void updateInternetScsiDigestProperties(String iScsiHbaDevice, HostInternetScsiHbaTargetSet targetSet, HostInternetScsiHbaDigestProperties digestProperties) throws NotFound, HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().updateInternetScsiDigestProperties(this.getMOR(), iScsiHbaDevice, targetSet, digestProperties);
    }

    public void updateScsiLunDisplayName(String lunUuid, String displayName) throws NotFound, HostConfigFault, InvalidName, DuplicateName, RuntimeFault, RemoteException {
        this.getVimService().updateScsiLunDisplayName(this.getMOR(), lunUuid, displayName);
    }

    public void updateInternetScsiDiscoveryProperties(String iScsiHbaDevice, HostInternetScsiHbaDiscoveryProperties discoveryProperties) throws NotFound, RuntimeFault, RemoteException {
        this.getVimService().updateInternetScsiDiscoveryProperties(this.getMOR(), iScsiHbaDevice, discoveryProperties);
    }

    public void updateInternetScsiIPProperties(String iScsiHbaDevice, HostInternetScsiHbaIPProperties ipProperties) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().updateInternetScsiIPProperties(this.getMOR(), iScsiHbaDevice, ipProperties);
    }

    public void updateInternetScsiName(String iScsiHbaDevice, String iScsiName) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().updateInternetScsiName(this.getMOR(), iScsiHbaDevice, iScsiName);
    }

    public void updateSoftwareInternetScsiEnabled(boolean enabled) throws HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().updateSoftwareInternetScsiEnabled(this.getMOR(), enabled);
    }

    public void upgradeVmfs(String vmfsPath) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().upgradeVmfs(this.getMOR(), vmfsPath);
    }

    public void upgradeVmLayout(String vmfsPath) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        this.getVimService().upgradeVmfs(this.getMOR(), vmfsPath);
    }
}

