/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.BackupBlobWriteFailure;
import com.vmware.vim25.DVSFeatureCapability;
import com.vmware.vim25.DVSManagerDvsConfigTarget;
import com.vmware.vim25.DistributedVirtualSwitchHostProductSpec;
import com.vmware.vim25.DistributedVirtualSwitchManagerCompatibilityResult;
import com.vmware.vim25.DistributedVirtualSwitchManagerDvsProductSpec;
import com.vmware.vim25.DistributedVirtualSwitchManagerHostContainer;
import com.vmware.vim25.DistributedVirtualSwitchManagerHostDvsFilterSpec;
import com.vmware.vim25.DistributedVirtualSwitchProductSpec;
import com.vmware.vim25.DvsFault;
import com.vmware.vim25.EntityBackupConfig;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.SelectionSet;
import com.vmware.vim25.mo.DistributedVirtualPortgroup;
import com.vmware.vim25.mo.DistributedVirtualSwitch;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.util.MorUtil;
import java.rmi.RemoteException;

public class DistributedVirtualSwitchManager
extends ManagedObject {
    public DistributedVirtualSwitchManager(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public DistributedVirtualSwitchProductSpec[] queryAvailableDvsSpec() throws RuntimeFault, RemoteException {
        return this.getVimService().queryAvailableDvsSpec(this.getMOR());
    }

    public HostSystem[] queryCompatibleHostForExistingDvs(ManagedEntity container, boolean recursive, DistributedVirtualSwitch dvs) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = this.getVimService().queryCompatibleHostForExistingDvs(this.getMOR(), container.getMOR(), recursive, dvs.getMOR());
        HostSystem[] hosts = new HostSystem[mors.length];
        for (int i2 = 0; i2 < hosts.length; ++i2) {
            hosts[i2] = new HostSystem(this.getServerConnection(), mors[i2]);
        }
        return hosts;
    }

    public HostSystem[] queryCompatibleHostForNewDvs(ManagedEntity container, boolean recursive, DistributedVirtualSwitchProductSpec switchProductSpec) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = this.getVimService().queryCompatibleHostForNewDvs(this.getMOR(), container.getMOR(), recursive, switchProductSpec);
        HostSystem[] hosts = new HostSystem[mors.length];
        for (int i2 = 0; i2 < hosts.length; ++i2) {
            hosts[i2] = new HostSystem(this.getServerConnection(), mors[i2]);
        }
        return hosts;
    }

    public DistributedVirtualSwitchHostProductSpec[] queryDvsCompatibleHostSpec(DistributedVirtualSwitchProductSpec switchProductSpec) throws RuntimeFault, RemoteException {
        return this.getVimService().queryDvsCompatibleHostSpec(this.getMOR(), switchProductSpec);
    }

    public DistributedVirtualSwitchManagerCompatibilityResult[] queryDvsCheckCompatibility(DistributedVirtualSwitchManagerHostContainer hostContainer, DistributedVirtualSwitchManagerDvsProductSpec dvsProductSpec, DistributedVirtualSwitchManagerHostDvsFilterSpec[] hostFilterSpec) throws RuntimeFault, RemoteException {
        return this.getVimService().queryDvsCheckCompatibility(this.getMOR(), hostContainer, dvsProductSpec, hostFilterSpec);
    }

    public DVSManagerDvsConfigTarget queryDvsConfigTarget(HostSystem host, DistributedVirtualSwitch dvs) throws RuntimeFault, RemoteException {
        return this.getVimService().queryDvsConfigTarget(this.getMOR(), host == null ? null : host.getMOR(), dvs == null ? null : dvs.getMOR());
    }

    public DistributedVirtualSwitch queryDvsByUuid(String uuid) throws NotFound, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().queryDvsByUuid(this.getMOR(), uuid);
        return new DistributedVirtualSwitch(this.getServerConnection(), mor);
    }

    public DVSFeatureCapability queryDvsFeatureCapability(DistributedVirtualSwitchProductSpec switchProductSpec) throws RuntimeFault, RemoteException {
        return this.getVimService().queryDvsFeatureCapability(this.getMOR(), switchProductSpec);
    }

    public Task rectifyDvsOnHost_Task(HostSystem[] hosts) throws DvsFault, RuntimeFault, RemoteException {
        ManagedObjectReference[] hostMors = MorUtil.createMORs(hosts);
        ManagedObjectReference taskMor = this.getVimService().rectifyDvsOnHost_Task(this.getMOR(), hostMors);
        return new Task(this.getServerConnection(), taskMor);
    }

    public Task dVSManagerExportEntity_Task(SelectionSet[] selectionSet) throws BackupBlobWriteFailure, NotFound, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().dVSManagerExportEntity_Task(this.getMOR(), selectionSet);
        return new Task(this.getServerConnection(), taskMor);
    }

    public Task dVSManagerImportEntity_Task(EntityBackupConfig[] entityBackup, String importType) throws DvsFault, NotFound, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().dVSManagerImportEntity_Task(this.getMOR(), entityBackup, importType);
        return new Task(this.getServerConnection(), taskMor);
    }

    public DistributedVirtualPortgroup dVSManagerLookupDvPortGroup(String switchUuid, String portgroupKey) throws NotFound, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().dVSManagerLookupDvPortGroup(this.getMOR(), switchUuid, portgroupKey);
        return new DistributedVirtualPortgroup(this.getServerConnection(), mor);
    }
}

