/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.AlarmDescription;
import com.vmware.vim25.AlarmExpression;
import com.vmware.vim25.AlarmSpec;
import com.vmware.vim25.AlarmState;
import com.vmware.vim25.DuplicateName;
import com.vmware.vim25.InvalidName;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.Alarm;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import java.rmi.RemoteException;

public class AlarmManager
extends ManagedObject {
    public AlarmManager(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public AlarmExpression[] getDefaultExpression() {
        return (AlarmExpression[])this.getCurrentProperty("defaultExpression");
    }

    public AlarmDescription getDescription() {
        return (AlarmDescription)this.getCurrentProperty("description");
    }

    public void acknowledgeAlarm(Alarm alarm, ManagedEntity entity) throws RuntimeFault, RemoteException {
        this.getVimService().acknowledgeAlarm(this.getMOR(), alarm.getMOR(), entity.getMOR());
    }

    public boolean areAlarmActionsEnabled(ManagedEntity entity) throws RuntimeFault, RemoteException {
        return this.getVimService().areAlarmActionsEnabled(this.getMOR(), entity.getMOR());
    }

    public void enableAlarmActions(ManagedEntity entity, boolean enabled) throws RuntimeFault, RemoteException {
        this.getVimService().enableAlarmActions(this.getMOR(), entity.getMOR(), enabled);
    }

    public Alarm createAlarm(ManagedEntity me, AlarmSpec as) throws InvalidName, DuplicateName, RuntimeFault, RemoteException {
        if (me == null) {
            throw new IllegalArgumentException("entity must not be null.");
        }
        ManagedObjectReference mor = this.getVimService().createAlarm(this.getMOR(), me.getMOR(), as);
        return new Alarm(this.getServerConnection(), mor);
    }

    public Alarm[] getAlarm(ManagedEntity me) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = this.getVimService().getAlarm(this.getMOR(), me == null ? null : me.getMOR());
        if (mors == null) {
            return new Alarm[0];
        }
        Alarm[] alarms = new Alarm[mors.length];
        for (int i2 = 0; i2 < mors.length; ++i2) {
            alarms[i2] = new Alarm(this.getServerConnection(), mors[i2]);
        }
        return alarms;
    }

    public AlarmState[] getAlarmState(ManagedEntity me) throws RuntimeFault, RemoteException {
        if (me == null) {
            throw new IllegalArgumentException("entity must not be null.");
        }
        return this.getVimService().getAlarmState(this.getMOR(), me.getMOR());
    }
}

