/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.cf;

import com.vmware.vim.cf.NullObject;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectUpdate;
import com.vmware.vim25.PropertyChange;
import com.vmware.vim25.PropertyFilterUpdate;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.util.MorUtil;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ManagedObjectCache
implements Observer {
    private Map<ManagedObjectReference, Map<String, Object>> items;
    private boolean isReady = false;
    private ServiceInstance si;

    ManagedObjectCache(ServiceInstance si) {
        this.si = si;
        this.items = new ConcurrentHashMap<ManagedObjectReference, Map<String, Object>>();
    }

    public Map<ManagedObjectReference, Map<String, Object>> getCachedItems() {
        return this.items;
    }

    @Override
    public void update(Observable obj, Object arg) {
        if (arg instanceof PropertyFilterUpdate[]) {
            PropertyFilterUpdate[] pfus = (PropertyFilterUpdate[])arg;
            for (int i2 = 0; pfus != null && i2 < pfus.length; ++i2) {
                ObjectUpdate[] ous = pfus[i2].getObjectSet();
                for (int j2 = 0; ous != null && j2 < ous.length; ++j2) {
                    ManagedObjectReference mor = ous[j2].getObj();
                    if (!this.items.containsKey(mor)) {
                        this.items.put(mor, new ConcurrentHashMap());
                    }
                    Map<String, Object> moMap = this.items.get(mor);
                    PropertyChange[] pcs = ous[j2].getChangeSet();
                    if (pcs == null) continue;
                    for (int k2 = 0; k2 < pcs.length; ++k2) {
                        Object value = pcs[k2].getVal();
                        value = value == null ? NullObject.NULL : value;
                        String propName = pcs[k2].getName();
                        if (moMap.containsKey(propName)) {
                            moMap.put(propName, value);
                            continue;
                        }
                        String parentPropName = this.getExistingParentPropName(moMap, propName);
                        if (parentPropName != null) {
                            ManagedObject mo = MorUtil.createExactManagedObject(this.si.getServerConnection(), mor);
                            moMap.put(parentPropName, mo.getPropertyByPath(parentPropName));
                            continue;
                        }
                        moMap.put(propName, value);
                    }
                }
            }
        }
        this.isReady = true;
    }

    private String getExistingParentPropName(Map<String, Object> moMap, String propName) {
        int lastDot;
        int pos = propName.indexOf("[");
        if (pos != -1) {
            propName = propName.substring(0, pos);
        }
        do {
            if ((lastDot = propName.lastIndexOf(".")) != -1) continue;
            return null;
        } while (!moMap.containsKey(propName = propName.substring(0, lastDot)));
        return propName;
    }

    public boolean isReady() {
        return this.isReady;
    }
}

