/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.SSLInputStream;
import com.sun.net.ssl.internal.ssl.SSLOutputStream;
import com.sun.net.ssl.internal.ssl.SunJSSE_k;
import com.sun.net.ssl.internal.ssl.SunJSSE_q;
import com.sun.net.ssl.internal.ssl.SunJSSE_t;
import com.sun.net.ssl.internal.ssl.SunJSSE_u;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLKeyException;

abstract class HandshakeMessage {
    static final byte a = 0;
    static final byte b = 1;
    static final byte c = 2;
    static final byte d = 11;
    static final byte e = 12;
    static final byte f = 13;
    static final byte g = 14;
    static final byte h = 15;
    static final byte i = 16;
    static final byte j = 20;
    static final Debug k = Debug.getInstance("ssl");

    HandshakeMessage() {
    }

    abstract int messageLength();

    abstract int messageType();

    abstract void a(PrintStream var1) throws IOException;

    abstract void send(SSLOutputStream var1) throws IOException;

    public final void write(SSLOutputStream sSLOutputStream) throws IOException {
        int n2 = this.messageLength();
        if (n2 > 0x1000000) {
            throw new SSLException("Handshake message too big, type = " + this.messageType() + ", len = " + n2);
        }
        sSLOutputStream.write(this.messageType());
        sSLOutputStream.b(this.messageLength());
        this.send(sSLOutputStream);
    }

    static final class CertificateMsg
    extends HandshakeMessage {
        private X509Certificate[] a;

        CertificateMsg(SSLInputStream sSLInputStream) throws IOException {
            int n2;
            int n3 = sSLInputStream.e();
            Vector<Certificate> vector = new Vector<Certificate>(3);
            while (n3 > 0) {
                n2 = sSLInputStream.e();
                byte[] byArray = new byte[n2];
                int n4 = 0;
                n3 -= 3 + n2;
                while (n4 != n2) {
                    int n5 = sSLInputStream.read(byArray, n4, n2 - n4);
                    if (n5 < 0) {
                        throw new IOException("short read of certificates");
                    }
                    n4 += n5;
                }
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    vector.addElement(certificateFactory.generateCertificate(new ByteArrayInputStream(byArray)));
                }
                catch (CertificateException certificateException) {
                    throw new IOException(certificateException.getMessage());
                }
            }
            this.a = new X509Certificate[vector.size()];
            n2 = 0;
            while (n2 < this.a.length) {
                this.a[n2] = (X509Certificate)vector.elementAt(n2);
                ++n2;
            }
        }

        CertificateMsg(X509Certificate[] x509CertificateArray) {
            this.a = x509CertificateArray;
        }

        public X509Certificate[] getCertificateChain() {
            return this.a;
        }

        int messageLength() {
            int n2 = 3;
            try {
                int n3 = this.a.length - 1;
                while (n3 >= 0) {
                    n2 += 3 + this.a[n3].getEncoded().length;
                    --n3;
                }
            }
            catch (CertificateException certificateException) {}
            return n2;
        }

        int messageType() {
            return 11;
        }

        void a(PrintStream printStream) throws IOException {
            printStream.println("*** Certificate chain");
            if (k != null && Debug.isOn("verbose")) {
                int n2 = 0;
                while (n2 < this.a.length) {
                    printStream.println("chain [" + n2 + "] = " + this.a[n2]);
                    ++n2;
                }
                printStream.println("***");
            }
        }

        void send(SSLOutputStream sSLOutputStream) throws IOException {
            try {
                sSLOutputStream.b(this.messageLength() - 3);
                int n2 = 0;
                while (n2 < this.a.length) {
                    sSLOutputStream.b(this.a[n2].getEncoded());
                    ++n2;
                }
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
        }
    }

    static final class DH_ServerKeyExchange
    extends SunJSSE_k {
        private static final boolean a = Debug.a("com.sun.net.ssl.dhKeyExchangeFix", true);
        private byte[] b;
        private byte[] c;
        private byte[] d;
        private byte[] e;

        DH_ServerKeyExchange(SunJSSE_u sunJSSE_u) {
            this.a(sunJSSE_u);
            this.e = null;
        }

        DH_ServerKeyExchange(SunJSSE_u sunJSSE_u, PrivateKey privateKey, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
            this.a(sunJSSE_u);
            if (privateKey instanceof DSAPrivateKey) {
                Signature signature = Signature.getInstance("DSA");
                signature.initSign(privateKey, secureRandom);
                this.a(signature, byArray, byArray2);
                this.e = signature.sign();
            } else {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                MessageDigest messageDigest2 = MessageDigest.getInstance("SHA-1");
                this.a(messageDigest, byArray, byArray2);
                this.a(messageDigest2, byArray, byArray2);
                SunJSSE_t sunJSSE_t = new SunJSSE_t(messageDigest.digest(), messageDigest2.digest(), privateKey, secureRandom);
                this.e = sunJSSE_t.a();
            }
        }

        DH_ServerKeyExchange(SSLInputStream sSLInputStream) throws IOException {
            this.b = sSLInputStream.a();
            this.c = sSLInputStream.a();
            this.d = sSLInputStream.a();
            this.e = null;
        }

        DH_ServerKeyExchange(SSLInputStream sSLInputStream, PublicKey publicKey, byte[] byArray, byte[] byArray2, int n2) throws IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
            boolean bl;
            this.b = sSLInputStream.a();
            this.c = sSLInputStream.a();
            this.d = sSLInputStream.a();
            if (a) {
                this.e = sSLInputStream.a();
            } else {
                n2 -= this.b.length + 2;
                n2 -= this.c.length + 2;
                this.e = new byte[n2 -= this.d.length + 2];
                sSLInputStream.read(this.e);
            }
            if (publicKey instanceof DSAKey) {
                Signature signature = Signature.getInstance("DSA");
                signature.initVerify(publicKey);
                this.a(signature, byArray, byArray2);
                bl = signature.verify(this.e);
            } else if (publicKey instanceof RSAPublicKey) {
                SunJSSE_t sunJSSE_t = new SunJSSE_t(this.e);
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                MessageDigest messageDigest2 = MessageDigest.getInstance("SHA-1");
                this.a(messageDigest, byArray, byArray2);
                this.a(messageDigest2, byArray, byArray2);
                bl = sunJSSE_t.a((RSAPublicKey)publicKey, messageDigest.digest(), messageDigest2.digest());
            } else {
                throw new SSLKeyException("neither an RSA or a DSA key");
            }
            if (!bl) {
                throw new SSLKeyException("Server D-H key verification failed");
            }
        }

        public BigInteger getBase() {
            return new BigInteger(1, this.c);
        }

        public BigInteger getModulus() {
            return new BigInteger(1, this.b);
        }

        public BigInteger getServerPublicKey() {
            return new BigInteger(1, this.d);
        }

        private void a(SunJSSE_u sunJSSE_u) {
            this.b = sunJSSE_u.b().toByteArray();
            this.c = sunJSSE_u.a().toByteArray();
            this.d = sunJSSE_u.d().toByteArray();
        }

        int messageLength() {
            int n2 = 6;
            n2 += this.b.length;
            n2 += this.c.length;
            n2 += this.d.length;
            if (this.e != null) {
                n2 += this.e.length;
                if (a) {
                    n2 += 2;
                }
            }
            return n2;
        }

        void a(PrintStream printStream) throws IOException {
            printStream.println("*** Diffie-Hellman ServerKeyExchange");
            if (k != null && Debug.isOn("verbose")) {
                printStream.print("DH Modulus = { ");
                int n2 = 0;
                while (n2 < this.b.length) {
                    if (n2 != 0) {
                        printStream.print(", ");
                    }
                    printStream.print(this.b[n2] & 0xFF);
                    ++n2;
                }
                printStream.println(" }");
                printStream.print("DH Base = { ");
                int n3 = 0;
                while (n3 < this.c.length) {
                    if (n3 != 0) {
                        printStream.print(", ");
                    }
                    printStream.print(this.c[n3] & 0xFF);
                    ++n3;
                }
                printStream.println(" }");
                printStream.print("Server DH Public Key = { ");
                int n4 = 0;
                while (n4 < this.d.length) {
                    if (n4 != 0) {
                        printStream.print(", ");
                    }
                    printStream.print(this.d[n4] & 0xFF);
                    ++n4;
                }
                printStream.println(" }");
                if (this.e == null) {
                    printStream.println("Anonymous");
                } else {
                    printStream.println("Signed with a DSA or RSA public key");
                }
            }
        }

        void send(SSLOutputStream sSLOutputStream) throws IOException {
            sSLOutputStream.a(this.b);
            sSLOutputStream.a(this.c);
            sSLOutputStream.a(this.d);
            if (this.e != null) {
                if (a) {
                    sSLOutputStream.a(this.e);
                } else {
                    sSLOutputStream.write(this.e);
                }
            }
        }

        private void a(MessageDigest messageDigest, byte[] byArray, byte[] byArray2) {
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            int n2 = this.b.length;
            messageDigest.update((byte)(n2 >> 8));
            messageDigest.update((byte)(n2 & 0xFF));
            messageDigest.update(this.b);
            n2 = this.c.length;
            messageDigest.update((byte)(n2 >> 8));
            messageDigest.update((byte)(n2 & 0xFF));
            messageDigest.update(this.c);
            n2 = this.d.length;
            messageDigest.update((byte)(n2 >> 8));
            messageDigest.update((byte)(n2 & 0xFF));
            messageDigest.update(this.d);
        }

        private void a(Signature signature, byte[] byArray, byte[] byArray2) throws SignatureException {
            signature.update(byArray);
            signature.update(byArray2);
            int n2 = this.b.length;
            signature.update((byte)(n2 >> 8));
            signature.update((byte)(n2 & 0xFF));
            signature.update(this.b);
            n2 = this.c.length;
            signature.update((byte)(n2 >> 8));
            signature.update((byte)(n2 & 0xFF));
            signature.update(this.c);
            n2 = this.d.length;
            signature.update((byte)(n2 >> 8));
            signature.update((byte)(n2 & 0xFF));
            signature.update(this.d);
        }
    }

    static final class Finished
    extends HandshakeMessage {
        byte a;
        byte b;
        static final byte[] c = new byte[]{67, 76, 78, 84};
        static final byte[] d = new byte[]{83, 82, 86, 82};
        static final String e = "client finished";
        static final String f = "server finished";
        byte[] g;
        byte[] h;
        byte[] i;

        Finished(byte by, byte by2, SSLInputStream sSLInputStream) throws IOException {
            this.a = by;
            this.b = by2;
            if (by == 3 && by2 == 1) {
                this.i = new byte[12];
                sSLInputStream.read(this.i);
            } else {
                this.g = new byte[16];
                this.h = new byte[20];
                sSLInputStream.read(this.g);
                sSLInputStream.read(this.h);
            }
        }

        Finished(byte by, byte by2, MessageDigest messageDigest, MessageDigest messageDigest2, String string, byte[] byArray) {
            this.a = by;
            this.b = by2;
            this.i = new byte[12];
            try {
                SunJSSE_q.a(byArray, string, messageDigest.digest(), messageDigest2.digest(), this.i);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("missing support for MD5/SHA-1");
            }
        }

        Finished(byte by, byte by2, MessageDigest messageDigest, MessageDigest messageDigest2, byte[] byArray, byte[] byArray2) {
            this.a = by;
            this.b = by2;
            this.g = this.a(messageDigest, byArray, byArray2, MAC.MD5_pad1, MAC.MD5_pad2);
            this.h = this.a(messageDigest2, byArray, byArray2, MAC.SHA_pad1, MAC.SHA_pad2);
        }

        private byte[] a(MessageDigest messageDigest, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            messageDigest.update(byArray3);
            byte[] byArray5 = messageDigest.digest();
            messageDigest.reset();
            messageDigest.update(byArray2);
            messageDigest.update(byArray4);
            messageDigest.update(byArray5);
            return messageDigest.digest();
        }

        int messageLength() {
            if (this.a == 3 && this.b == 1) {
                return 12;
            }
            return 36;
        }

        int messageType() {
            return 20;
        }

        void a(PrintStream printStream) throws IOException {
            printStream.println("*** Finished, v" + this.a + "." + this.b);
            if (k != null && Debug.isOn("verbose")) {
                if (this.a == 3 && this.b == 1) {
                    printStream.print("verify_data:  { ");
                    int n2 = 0;
                    while (n2 < this.i.length) {
                        if (n2 != 0) {
                            printStream.print(", ");
                        }
                        printStream.print(this.i[n2] & 0xFF);
                        ++n2;
                    }
                    printStream.println(" }");
                    printStream.println("***");
                } else {
                    printStream.print("MD5 Hash:  { ");
                    int n3 = 0;
                    while (n3 < this.g.length) {
                        if (n3 != 0) {
                            printStream.print(", ");
                        }
                        printStream.print(this.g[n3] & 0xFF);
                        ++n3;
                    }
                    printStream.println(" }");
                    printStream.print("SHA1 Hash:  { ");
                    n3 = 0;
                    while (n3 < this.h.length) {
                        if (n3 != 0) {
                            printStream.print(", ");
                        }
                        printStream.print(this.h[n3] & 0xFF);
                        ++n3;
                    }
                    printStream.println(" }");
                    printStream.println("***");
                }
            }
        }

        void send(SSLOutputStream sSLOutputStream) throws IOException {
            if (this.a == 3 && this.b == 1) {
                sSLOutputStream.write(this.i);
            } else {
                sSLOutputStream.write(this.g);
                sSLOutputStream.write(this.h);
            }
        }

        public boolean verify(MessageDigest messageDigest, MessageDigest messageDigest2, Object object, byte[] byArray) {
            if (object instanceof String) {
                if (this.i == null) {
                    return false;
                }
                byte[] byArray2 = new byte[12];
                try {
                    SunJSSE_q.a(byArray, (String)object, messageDigest.digest(), messageDigest2.digest(), byArray2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException("missing support for MD5/SHA-1");
                }
                int n2 = 0;
                while (n2 < 12) {
                    if (this.i[n2] != byArray2[n2]) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            if (this.g == null || this.h == null) {
                return false;
            }
            byte[] byArray3 = this.a(messageDigest, (byte[])object, byArray, MAC.MD5_pad1, MAC.MD5_pad2);
            byte[] byArray4 = this.a(messageDigest2, (byte[])object, byArray, MAC.SHA_pad1, MAC.SHA_pad2);
            int n3 = 0;
            while (n3 < 16) {
                if (this.g[n3] != byArray3[n3]) {
                    return false;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < 20) {
                if (this.h[n3] != byArray4[n3]) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
    }
}

