/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.AssertionFailedException;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.NotUpdatable;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowData;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UpdatableResultSet
extends ResultSet {
    private static final byte[] STREAM_DATA_MARKER = "** STREAM DATA **".getBytes();
    private List primaryKeyIndicies = null;
    private PreparedStatement deleter = null;
    private PreparedStatement inserter = null;
    private PreparedStatement refresher;
    private PreparedStatement updater = null;
    private SingleByteCharsetConverter charConverter;
    private String charEncoding;
    private String deleteSQL = null;
    private String insertSQL = null;
    private String quotedIdChar = null;
    private String refreshSQL = null;
    private String qualifiedAndQuotedTableName;
    private String tableOnlyName;
    private String updateSQL = null;
    private byte[][] defaultColumnValue;
    private byte[][] savedCurrentRow;
    private boolean isUpdatable = false;
    private boolean initializedCharConverter = false;

    public UpdatableResultSet(long updateCount, long updateID) {
        super(updateCount, updateID);
    }

    public UpdatableResultSet(String catalog, Field[] fields, RowData rows, Connection conn) throws SQLException {
        super(catalog, fields, rows, conn);
        this.isUpdatable = this.checkUpdatability();
    }

    public UpdatableResultSet(Field[] fields, RowData rows) throws SQLException {
        super(fields, rows);
        this.isUpdatable = this.checkUpdatability();
    }

    public synchronized boolean isAfterLast() throws SQLException {
        return super.isAfterLast();
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        return super.isBeforeFirst();
    }

    public int getConcurrency() throws SQLException {
        return this.isUpdatable ? 1008 : 1007;
    }

    public synchronized boolean isFirst() throws SQLException {
        return super.isFirst();
    }

    public synchronized boolean isLast() throws SQLException {
        return super.isLast();
    }

    public synchronized boolean absolute(int row) throws SQLException {
        return super.absolute(row);
    }

    public synchronized void afterLast() throws SQLException {
        super.afterLast();
    }

    public synchronized void beforeFirst() throws SQLException {
        super.beforeFirst();
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        if (this.doingUpdates) {
            this.doingUpdates = false;
            this.updater.clearParameters();
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    public synchronized void close() throws SQLException {
        super.close();
    }

    public synchronized void deleteRow() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        if (this.onInsertRow) {
            throw new SQLException("Can not call deleteRow() when on insert row");
        }
        if (this.rowData.size() == 0) {
            throw new SQLException("Can't deleteRow() on empty result set");
        }
        if (this.isBeforeFirst()) {
            throw new SQLException("Before start of result set. Can not call deleteRow().");
        }
        if (this.isAfterLast()) {
            throw new SQLException("After end of result set. Can not call deleteRow().");
        }
        if (this.deleter == null) {
            if (this.deleteSQL == null) {
                this.generateStatements();
            }
            this.deleter = (PreparedStatement)this.connection.prepareStatement(this.deleteSQL);
            if (this.deleter.getMaxRows() != 0) {
                this.deleter.setMaxRows(0);
            }
        }
        this.deleter.clearParameters();
        String characterEncoding = null;
        if (this.connection.useUnicode()) {
            characterEncoding = this.connection.getEncoding();
        }
        try {
            int numKeys = this.primaryKeyIndicies.size();
            if (numKeys == 1) {
                int index = (Integer)this.primaryKeyIndicies.get(0);
                String currentVal = characterEncoding == null ? new String(this.thisRow[index]) : new String(this.thisRow[index], characterEncoding);
                this.deleter.setString(1, currentVal);
            } else {
                int i2 = 0;
                while (i2 < numKeys) {
                    int index = (Integer)this.primaryKeyIndicies.get(i2);
                    String currentVal = characterEncoding == null ? new String(this.thisRow[index]) : new String(this.thisRow[index], characterEncoding);
                    this.deleter.setString(i2 + 1, currentVal);
                    ++i2;
                }
            }
            this.deleter.executeUpdate();
            this.rowData.removeRow(this.rowData.getCurrentRowNumber());
        }
        catch (UnsupportedEncodingException encodingEx) {
            throw new SQLException("Unsupported character encoding '" + this.connection.getEncoding() + "'");
        }
    }

    public synchronized boolean first() throws SQLException {
        return super.first();
    }

    public synchronized void insertRow() throws SQLException {
        if (!this.onInsertRow) {
            throw new SQLException("Not on insert row");
        }
        this.inserter.executeUpdate();
        int numPrimaryKeys = 0;
        if (this.primaryKeyIndicies != null) {
            numPrimaryKeys = this.primaryKeyIndicies.size();
        }
        long autoIncrementId = this.inserter.getLastInsertID();
        int numFields = this.fields.length;
        byte[][] newRow = new byte[numFields][];
        int i2 = 0;
        while (i2 < numFields) {
            newRow[i2] = (byte[])(this.inserter.isNull(i2) ? null : this.inserter.getBytes(i2));
            if (numPrimaryKeys == 1 && this.fields[i2].isPrimaryKey() && autoIncrementId > 0L) {
                newRow[i2] = String.valueOf(autoIncrementId).getBytes();
            }
            ++i2;
        }
        this.rowData.addRow(newRow);
        this.resetInserter();
    }

    public synchronized boolean last() throws SQLException {
        return super.last();
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        if (this.onInsertRow) {
            this.onInsertRow = false;
            this.thisRow = this.savedCurrentRow;
        }
    }

    public synchronized void moveToInsertRow() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        if (this.inserter == null) {
            this.generateStatements();
            this.inserter = (PreparedStatement)this.connection.prepareStatement(this.insertSQL);
            if (this.inserter.getMaxRows() != 0) {
                this.inserter.setMaxRows(0);
            }
            this.extractDefaultValues();
            this.resetInserter();
        } else {
            this.resetInserter();
        }
        int numFields = this.fields.length;
        this.onInsertRow = true;
        this.doingUpdates = false;
        this.savedCurrentRow = this.thisRow;
        this.thisRow = new byte[numFields][];
        int i2 = 0;
        while (i2 < numFields) {
            if (this.defaultColumnValue[i2] != null) {
                this.inserter.setBytes(i2 + 1, this.defaultColumnValue[i2]);
                byte[] defaultValueCopy = new byte[this.defaultColumnValue[i2].length];
                System.arraycopy(this.defaultColumnValue[i2], 0, defaultValueCopy, 0, defaultValueCopy.length);
                this.thisRow[i2] = defaultValueCopy;
            } else {
                this.inserter.setNull(i2 + 1, 0);
                this.thisRow[i2] = null;
            }
            ++i2;
        }
    }

    public synchronized boolean next() throws SQLException {
        return super.next();
    }

    public synchronized boolean prev() throws SQLException {
        return super.prev();
    }

    public synchronized boolean previous() throws SQLException {
        return super.previous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void refreshRow() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        if (this.onInsertRow) {
            throw new SQLException("Can not call refreshRow() when on insert row");
        }
        if (this.rowData.size() == 0) {
            throw new SQLException("Can't refreshRow() on empty result set");
        }
        if (this.isBeforeFirst()) {
            throw new SQLException("Before start of result set. Can not call refreshRow().");
        }
        if (this.isAfterLast()) {
            throw new SQLException("After end of result set. Can not call refreshRow().");
        }
        if (this.refresher == null) {
            if (this.refreshSQL == null) {
                this.generateStatements();
            }
            this.refresher = (PreparedStatement)this.connection.prepareStatement(this.refreshSQL);
            if (this.refresher.getMaxRows() != 0) {
                this.refresher.setMaxRows(0);
            }
        }
        this.refresher.clearParameters();
        int numKeys = this.primaryKeyIndicies.size();
        if (numKeys == 1) {
            byte[] dataFrom = null;
            int index = (Integer)this.primaryKeyIndicies.get(0);
            if (!this.doingUpdates) {
                dataFrom = this.thisRow[index];
            } else {
                dataFrom = this.updater.getBytes(index);
                if (this.updater.isNull(index) || dataFrom.length == 0) {
                    dataFrom = this.thisRow[index];
                }
            }
            this.refresher.setBytesNoEscape(1, dataFrom);
        } else {
            int i2 = 0;
            while (i2 < numKeys) {
                byte[] dataFrom = null;
                int index = (Integer)this.primaryKeyIndicies.get(i2);
                if (!this.doingUpdates) {
                    dataFrom = this.thisRow[index];
                } else {
                    dataFrom = this.updater.getBytes(index);
                    if (this.updater.isNull(index) || dataFrom.length == 0) {
                        dataFrom = this.thisRow[index];
                    }
                }
                this.refresher.setBytesNoEscape(i2 + 1, dataFrom);
                ++i2;
            }
        }
        java.sql.ResultSet rs = null;
        try {
            rs = this.refresher.executeQuery();
            int numCols = rs.getMetaData().getColumnCount();
            if (!rs.next()) throw new SQLException("refreshRow() called on row that has been deleted or had primary key changed", "S1000");
            int i3 = 0;
            while (i3 < numCols) {
                byte[] val = rs.getBytes(i3 + 1);
                this.thisRow[i3] = (byte[])(val == null || rs.wasNull() ? null : rs.getBytes(i3 + 1));
                ++i3;
            }
            Object var7_9 = null;
            if (rs == null) return;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            rs.close();
            return;
        }
        catch (SQLException ex) {}
    }

    public synchronized boolean relative(int rows) throws SQLException {
        return super.relative(rows);
    }

    public synchronized boolean rowDeleted() throws SQLException {
        throw new NotImplemented();
    }

    public synchronized boolean rowInserted() throws SQLException {
        throw new NotImplemented();
    }

    public synchronized boolean rowUpdated() throws SQLException {
        throw new NotImplemented();
    }

    public synchronized void updateAsciiStream(int columnIndex, InputStream x2, int length) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setAsciiStream(columnIndex, x2, length);
        } else {
            this.inserter.setAsciiStream(columnIndex, x2, length);
            this.thisRow[columnIndex - 1] = STREAM_DATA_MARKER;
        }
    }

    public synchronized void updateAsciiStream(String columnName, InputStream x2, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x2, length);
    }

    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x2) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setBigDecimal(columnIndex, x2);
        } else {
            this.inserter.setBigDecimal(columnIndex, x2);
            this.thisRow[columnIndex - 1] = (byte[])(x2 == null ? null : x2.toString().getBytes());
        }
    }

    public synchronized void updateBigDecimal(String columnName, BigDecimal x2) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x2);
    }

    public synchronized void updateBinaryStream(int columnIndex, InputStream x2, int length) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setBinaryStream(columnIndex, x2, length);
        } else {
            this.inserter.setBinaryStream(columnIndex, x2, length);
            this.thisRow[columnIndex - 1] = (byte[])(x2 == null ? null : STREAM_DATA_MARKER);
        }
    }

    public synchronized void updateBinaryStream(String columnName, InputStream x2, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x2, length);
    }

    public synchronized void updateBlob(int columnIndex, Blob blob) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setBlob(columnIndex, blob);
        } else {
            this.inserter.setBlob(columnIndex, blob);
            this.thisRow[columnIndex - 1] = (byte[])(blob == null ? null : STREAM_DATA_MARKER);
        }
    }

    public void updateBlob(String columnName, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(columnName), blob);
    }

    public synchronized void updateBoolean(int columnIndex, boolean x2) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setBoolean(columnIndex, x2);
        } else {
            this.inserter.setBoolean(columnIndex, x2);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(1);
        }
    }

    public synchronized void updateBoolean(String columnName, boolean x2) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x2);
    }

    public synchronized void updateByte(int columnIndex, byte x2) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setByte(columnIndex, x2);
        } else {
            this.inserter.setByte(columnIndex, x2);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex);
        }
    }

    public synchronized void updateByte(String columnName, byte x2) throws SQLException {
        this.updateByte(this.findColumn(columnName), x2);
    }

    public synchronized void updateBytes(int columnIndex, byte[] x2) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setBytes(columnIndex, x2);
        } else {
            this.inserter.setBytes(columnIndex, x2);
            this.thisRow[columnIndex - 1] = x2;
        }
    }

    public synchronized void updateBytes(String columnName, byte[] x2) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x2);
    }

    public synchronized void updateCharacterStream(int columnIndex, Reader x2, int length) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setCharacterStream(columnIndex, x2, length);
        } else {
            this.inserter.setCharacterStream(columnIndex, x2, length);
            this.thisRow[columnIndex - 1] = (byte[])(x2 == null ? null : STREAM_DATA_MARKER);
        }
    }

    public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public void updateClob(int columnIndex, Clob clob) throws SQLException {
        if (clob == null) {
            this.updateNull(columnIndex);
        } else {
            this.updateCharacterStream(columnIndex, clob.getCharacterStream(), (int)clob.length());
        }
    }

    public synchronized void updateDate(int columnIndex, Date x2) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setDate(columnIndex, x2);
        } else {
            this.inserter.setDate(columnIndex, x2);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateDate(String columnName, Date x2) throws SQLException {
        this.updateDate(this.findColumn(columnName), x2);
    }

    public synchronized void updateDouble(int columnIndex, double x2) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setDouble(columnIndex, x2);
        } else {
            this.inserter.setDouble(columnIndex, x2);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateDouble(String columnName, double x2) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x2);
    }

    public synchronized void updateFloat(int columnIndex, float x2) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setFloat(columnIndex, x2);
        } else {
            this.inserter.setFloat(columnIndex, x2);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateFloat(String columnName, float x2) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x2);
    }

    public synchronized void updateInt(int columnIndex, int x2) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setInt(columnIndex, x2);
        } else {
            this.inserter.setInt(columnIndex, x2);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateInt(String columnName, int x2) throws SQLException {
        this.updateInt(this.findColumn(columnName), x2);
    }

    public synchronized void updateLong(int columnIndex, long x2) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setLong(columnIndex, x2);
        } else {
            this.inserter.setLong(columnIndex, x2);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateLong(String columnName, long x2) throws SQLException {
        this.updateLong(this.findColumn(columnName), x2);
    }

    public synchronized void updateNull(int columnIndex) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setNull(columnIndex, 0);
        } else {
            this.inserter.setNull(columnIndex, 0);
            this.thisRow[columnIndex - 1] = null;
        }
    }

    public synchronized void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public synchronized void updateObject(int columnIndex, Object x2, int scale) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setObject(columnIndex, x2);
        } else {
            this.inserter.setObject(columnIndex, x2);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateObject(int columnIndex, Object x2) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setObject(columnIndex, x2);
        } else {
            this.inserter.setObject(columnIndex, x2);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateObject(String columnName, Object x2, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x2);
    }

    public synchronized void updateObject(String columnName, Object x2) throws SQLException {
        this.updateObject(this.findColumn(columnName), x2);
    }

    public synchronized void updateRow() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        if (this.doingUpdates) {
            this.updater.executeUpdate();
            this.refreshRow();
            this.doingUpdates = false;
        }
        this.syncUpdate();
    }

    public synchronized void updateShort(int columnIndex, short x2) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setShort(columnIndex, x2);
        } else {
            this.inserter.setShort(columnIndex, x2);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateShort(String columnName, short x2) throws SQLException {
        this.updateShort(this.findColumn(columnName), x2);
    }

    public synchronized void updateString(int columnIndex, String x2) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setString(columnIndex, x2);
        } else {
            this.inserter.setString(columnIndex, x2);
            if (x2 == null) {
                this.thisRow[columnIndex - 1] = null;
            } else if (this.getCharConverter() != null) {
                try {
                    this.thisRow[columnIndex - 1] = StringUtils.getBytes(x2, this.charConverter, this.charEncoding, this.connection.parserKnowsUnicode());
                }
                catch (UnsupportedEncodingException uEE) {
                    throw new SQLException("Unsupported character encoding '" + this.charEncoding + "'", "S1009");
                }
            } else {
                this.thisRow[columnIndex - 1] = x2.getBytes();
            }
        }
    }

    public synchronized void updateString(String columnName, String x2) throws SQLException {
        this.updateString(this.findColumn(columnName), x2);
    }

    public synchronized void updateTime(int columnIndex, Time x2) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setTime(columnIndex, x2);
        } else {
            this.inserter.setTime(columnIndex, x2);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateTime(String columnName, Time x2) throws SQLException {
        this.updateTime(this.findColumn(columnName), x2);
    }

    public synchronized void updateTimestamp(int columnIndex, Timestamp x2) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setTimestamp(columnIndex, x2);
        } else {
            this.inserter.setTimestamp(columnIndex, x2);
            this.thisRow[columnIndex - 1] = this.inserter.getBytes(columnIndex - 1);
        }
    }

    public synchronized void updateTimestamp(String columnName, Timestamp x2) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x2);
    }

    protected void setResultSetConcurrency(int concurrencyFlag) {
        super.setResultSetConcurrency(concurrencyFlag);
    }

    protected void checkRowPos() throws SQLException {
        if (!this.onInsertRow) {
            super.checkRowPos();
        }
    }

    protected synchronized void generateStatements() throws SQLException {
        StringBuffer tableNameBuffer;
        if (!this.isUpdatable) {
            this.doingUpdates = false;
            this.onInsertRow = false;
            throw new NotUpdatable();
        }
        String quotedId = this.getQuotedIdChar();
        this.qualifiedAndQuotedTableName = null;
        this.tableOnlyName = null;
        if (this.fields[0].getOriginalTableName() != null) {
            tableNameBuffer = new StringBuffer();
            String databaseName = this.fields[0].getDatabaseName();
            if (databaseName != null && databaseName.length() > 0) {
                tableNameBuffer.append(quotedId);
                tableNameBuffer.append(databaseName);
                tableNameBuffer.append(quotedId);
                tableNameBuffer.append('.');
            }
            this.tableOnlyName = this.fields[0].getOriginalTableName();
            tableNameBuffer.append(quotedId);
            tableNameBuffer.append(this.tableOnlyName);
            tableNameBuffer.append(quotedId);
            this.qualifiedAndQuotedTableName = tableNameBuffer.toString();
        } else {
            tableNameBuffer = new StringBuffer();
            this.tableOnlyName = this.fields[0].getTableName();
            tableNameBuffer.append(quotedId);
            tableNameBuffer.append(this.tableOnlyName);
            tableNameBuffer.append(quotedId);
            this.qualifiedAndQuotedTableName = tableNameBuffer.toString();
        }
        this.primaryKeyIndicies = new ArrayList();
        StringBuffer fieldValues = new StringBuffer();
        StringBuffer keyValues = new StringBuffer();
        StringBuffer columnNames = new StringBuffer();
        StringBuffer insertPlaceHolders = new StringBuffer();
        boolean firstTime = true;
        boolean keysFirstTime = true;
        int i2 = 0;
        while (i2 < this.fields.length) {
            String originalColumnName = this.fields[i2].getOriginalName();
            String columnName = null;
            columnName = this.connection.getIO().hasLongColumnInfo() && originalColumnName != null && originalColumnName.length() > 0 ? originalColumnName : this.fields[i2].getName();
            if (this.fields[i2].isPrimaryKey()) {
                this.primaryKeyIndicies.add(new Integer(i2));
                if (!keysFirstTime) {
                    keyValues.append(" AND ");
                } else {
                    keysFirstTime = false;
                }
                keyValues.append(quotedId);
                keyValues.append(columnName);
                keyValues.append(quotedId);
                keyValues.append("=?");
            }
            if (firstTime) {
                firstTime = false;
                fieldValues.append("SET ");
            } else {
                fieldValues.append(",");
                columnNames.append(",");
                insertPlaceHolders.append(",");
            }
            insertPlaceHolders.append("?");
            columnNames.append(quotedId);
            columnNames.append(columnName);
            columnNames.append(quotedId);
            fieldValues.append(quotedId);
            fieldValues.append(columnName);
            fieldValues.append(quotedId);
            fieldValues.append("=?");
            ++i2;
        }
        this.updateSQL = "UPDATE " + this.qualifiedAndQuotedTableName + " " + fieldValues.toString() + " WHERE " + keyValues.toString();
        this.insertSQL = "INSERT INTO " + this.qualifiedAndQuotedTableName + " (" + columnNames.toString() + ") VALUES (" + insertPlaceHolders.toString() + ")";
        this.refreshSQL = "SELECT " + columnNames.toString() + " FROM " + this.qualifiedAndQuotedTableName + " WHERE " + keyValues.toString();
        this.deleteSQL = "DELETE FROM " + this.qualifiedAndQuotedTableName + " WHERE " + keyValues.toString();
    }

    synchronized boolean isUpdatable() {
        return this.isUpdatable;
    }

    synchronized void syncUpdate() throws SQLException {
        if (this.updater == null) {
            if (this.updateSQL == null) {
                this.generateStatements();
            }
            this.updater = (PreparedStatement)this.connection.prepareStatement(this.updateSQL);
            if (this.updater.getMaxRows() != 0) {
                this.updater.setMaxRows(0);
            }
        }
        int numFields = this.fields.length;
        this.updater.clearParameters();
        int i2 = 0;
        while (i2 < numFields) {
            if (this.thisRow[i2] != null) {
                this.updater.setBytes(i2 + 1, this.thisRow[i2]);
            } else {
                this.updater.setNull(i2 + 1, 0);
            }
            ++i2;
        }
        int numKeys = this.primaryKeyIndicies.size();
        if (numKeys == 1) {
            int index = (Integer)this.primaryKeyIndicies.get(0);
            byte[] keyData = this.thisRow[index];
            this.updater.setBytes(numFields + 1, keyData);
        } else {
            int i3 = 0;
            while (i3 < numKeys) {
                byte[] currentVal = this.thisRow[(Integer)this.primaryKeyIndicies.get(i3)];
                if (currentVal != null) {
                    this.updater.setBytes(numFields + i3 + 1, currentVal);
                } else {
                    this.updater.setNull(numFields + i3 + 1, 0);
                }
                ++i3;
            }
        }
    }

    private synchronized SingleByteCharsetConverter getCharConverter() throws SQLException {
        if (!this.initializedCharConverter) {
            this.initializedCharConverter = true;
            if (this.connection.useUnicode()) {
                this.charEncoding = this.connection.getEncoding();
                this.charConverter = this.connection.getCharsetConverter(this.charEncoding);
            }
        }
        return this.charConverter;
    }

    private synchronized String getQuotedIdChar() throws SQLException {
        if (this.quotedIdChar == null) {
            boolean useQuotedIdentifiers = this.connection.supportsQuotedIdentifiers();
            if (useQuotedIdentifiers) {
                DatabaseMetaData dbmd = this.connection.getMetaData();
                this.quotedIdChar = dbmd.getIdentifierQuoteString();
            } else {
                this.quotedIdChar = "";
            }
        }
        return this.quotedIdChar;
    }

    private String getTableName(Field field) {
        String originalTableName = field.getOriginalTableName();
        if (originalTableName != null && originalTableName.length() > 0) {
            return originalTableName;
        }
        return field.getTableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkUpdatability() throws SQLException {
        String tableName = null;
        String catalogName = null;
        int primaryKeyCount = 0;
        if (this.fields.length > 0) {
            tableName = this.fields[0].getOriginalTableName();
            catalogName = this.fields[0].getDatabaseName();
            if (tableName == null) {
                tableName = this.fields[0].getTableName();
                catalogName = this.catalog;
            }
            if (this.fields[0].isPrimaryKey()) {
                ++primaryKeyCount;
            }
            int i2 = 1;
            while (i2 < this.fields.length) {
                String otherTableName = this.fields[i2].getOriginalTableName();
                String otherCatalogName = this.fields[i2].getDatabaseName();
                if (otherTableName == null) {
                    otherTableName = this.fields[i2].getTableName();
                    otherCatalogName = this.catalog;
                }
                if (tableName == null || !otherTableName.equals(tableName)) {
                    return false;
                }
                if (catalogName == null || !otherCatalogName.equals(catalogName)) {
                    return false;
                }
                if (this.fields[i2].isPrimaryKey()) {
                    ++primaryKeyCount;
                }
                ++i2;
            }
            if (tableName == null || tableName.length() == 0) {
                return false;
            }
        } else {
            return false;
        }
        if (primaryKeyCount == 0) {
            return false;
        }
        if (this.catalog == null || this.catalog.length() == 0) {
            this.catalog = this.fields[0].getDatabaseName();
            if (this.catalog == null || this.catalog.length() == 0) {
                throw new SQLException("Can not create updatable result sets when there is no currently selected database and MySQL server version < 4.1", "S1009");
            }
        }
        if (this.connection.useStrictUpdates()) {
            HashMap<String, String> primaryKeyNames;
            block24: {
                DatabaseMetaData dbmd = this.connection.getMetaData();
                java.sql.ResultSet rs = null;
                primaryKeyNames = new HashMap<String, String>();
                try {
                    rs = dbmd.getPrimaryKeys(catalogName, null, tableName);
                    while (rs.next()) {
                        String keyName = rs.getString(4);
                        keyName = keyName.toUpperCase();
                        primaryKeyNames.put(keyName, keyName);
                    }
                    Object var9_10 = null;
                    if (rs == null) break block24;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception ex) {
                            AssertionFailedException.shouldNotHappen(ex);
                        }
                        rs = null;
                    }
                    throw throwable;
                }
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    AssertionFailedException.shouldNotHappen(ex);
                }
                rs = null;
                {
                }
            }
            if (primaryKeyNames.size() == 0) {
                return false;
            }
            int i3 = 0;
            while (i3 < this.fields.length) {
                String originalName;
                String columnNameUC;
                if (this.fields[i3].isPrimaryKey() && primaryKeyNames.remove(columnNameUC = this.fields[i3].getName().toUpperCase()) == null && (originalName = this.fields[i3].getOriginalName()) != null && primaryKeyNames.remove(originalName.toUpperCase()) == null) {
                    return false;
                }
                ++i3;
            }
            return primaryKeyNames.isEmpty();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void extractDefaultValues() throws SQLException {
        DatabaseMetaData dbmd = this.connection.getMetaData();
        java.sql.ResultSet columnsResultSet = null;
        try {
            columnsResultSet = dbmd.getColumns(this.catalog, null, this.tableOnlyName, "%");
            HashMap<String, byte[]> columnNameToDefaultValueMap = new HashMap<String, byte[]>(this.fields.length);
            while (columnsResultSet.next()) {
                String columnName = columnsResultSet.getString("COLUMN_NAME");
                byte[] defaultValue = columnsResultSet.getBytes("COLUMN_DEF");
                columnNameToDefaultValueMap.put(columnName, defaultValue);
            }
            int numFields = this.fields.length;
            this.defaultColumnValue = new byte[numFields][];
            int i2 = 0;
            while (i2 < numFields) {
                String tableName = this.fields[i2].getOriginalName();
                if (tableName == null || tableName.length() == 0) {
                    tableName = this.fields[i2].getName();
                }
                if (tableName != null) {
                    byte[] defaultVal = (byte[])columnNameToDefaultValueMap.get(tableName);
                    this.defaultColumnValue[i2] = defaultVal;
                }
                ++i2;
            }
            Object var9_10 = null;
            if (columnsResultSet == null) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (columnsResultSet == null) throw throwable;
            columnsResultSet.close();
            columnsResultSet = null;
            throw throwable;
        }
        columnsResultSet.close();
    }

    private void resetInserter() throws SQLException {
        this.inserter.clearParameters();
        int i2 = 0;
        while (i2 < this.fields.length) {
            this.inserter.setNull(i2 + 1, 0);
            ++i2;
        }
    }
}

