/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.inet.sftp.requests;

import com.jscape.inet.file.JFileType;
import com.jscape.inet.sftp.RequestException;
import com.jscape.inet.sftp.SftpClient;
import com.jscape.inet.sftp.SftpException;
import com.jscape.inet.sftp.SftpExceptionFactory;
import com.jscape.inet.sftp.SftpPacket;
import com.jscape.inet.sftp.packets.SftpFileAttributes;
import com.jscape.inet.sftp.packets.SshFxpAttrs;
import com.jscape.inet.sftp.packets.SshFxpLstat;
import com.jscape.inet.sftp.packets.SshFxpStat;
import com.jscape.inet.sftp.packets.SshFxpStatus;
import com.jscape.inet.sftp.requests.Request;
import com.jscape.inet.sftp.requests.SetAttributesRequest;
import com.jscape.util.i;
import java.util.Date;

public class AttributesRequest
implements Request {
    protected String path;
    protected boolean followLink;
    protected Long size;
    protected Integer permissions;
    protected Date modificationDate;
    protected Boolean isDirectory;
    private static final String z;

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        i.a(string);
        this.path = string;
    }

    public boolean getFollowLink() {
        return this.followLink;
    }

    public void setFollowLink(boolean bl) {
        this.followLink = bl;
    }

    public Long getSize() {
        return this.size;
    }

    public Integer getPermissions() {
        return this.permissions;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public Boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isValid() {
        return this.path != null;
    }

    public void execute(SftpClient sftpClient) throws SftpException {
        i.c(this.isValid(), z);
        this.initResults();
        SftpPacket sftpPacket = this.getRequestPacket();
        SftpPacket sftpPacket2 = sftpClient.sendRequest(sftpPacket);
        AttributesRequest attributesRequest = this;
        SftpPacket sftpPacket3 = sftpPacket2;
        if (SetAttributesRequest.a == 0) {
            if (!attributesRequest.isValidResponse(sftpPacket3)) {
                throw this.getException(sftpPacket, sftpPacket2);
            }
            attributesRequest = this;
            sftpPacket3 = sftpPacket2;
        }
        attributesRequest.processResponse(sftpPacket3);
    }

    protected void initResults() {
        this.size = null;
        this.permissions = null;
        this.modificationDate = null;
        this.isDirectory = null;
    }

    protected SftpPacket getRequestPacket() {
        return this.followLink ? new SshFxpLstat(this.path) : new SshFxpStat(this.path);
    }

    protected boolean isValidResponse(SftpPacket sftpPacket) {
        return sftpPacket.getClass().equals(SshFxpAttrs.class);
    }

    protected void processResponse(SftpPacket sftpPacket) {
        int n2 = SetAttributesRequest.a;
        SftpFileAttributes sftpFileAttributes = ((SshFxpAttrs)sftpPacket).getAttrs();
        boolean bl = sftpFileAttributes.getFlags().isSizePresent();
        if (n2 == 0) {
            if (bl) {
                this.size = new Long(sftpFileAttributes.getSize());
            }
            bl = sftpFileAttributes.getFlags().isPermissionsPresent();
        }
        if (n2 == 0) {
            if (bl) {
                int n3 = sftpFileAttributes.getPermissions().getOwnerPermission().intValue();
                int n4 = sftpFileAttributes.getPermissions().getGroupPermission().intValue();
                int n5 = sftpFileAttributes.getPermissions().getOtherPermission().intValue();
                this.permissions = new Integer(n3 * 100 + n4 * 10 + n5);
                this.isDirectory = new Boolean(sftpFileAttributes.getPermissions().getType() == JFileType.DIRECTORY);
            }
            bl = sftpFileAttributes.getFlags().isAcModTimePresent();
        }
        if (bl) {
            this.modificationDate = new Date(sftpFileAttributes.getMtime() * 1000L);
        }
    }

    protected SftpException getException(SftpPacket sftpPacket, SftpPacket sftpPacket2) {
        block3: {
            SftpPacket sftpPacket3;
            block2: {
                sftpPacket3 = sftpPacket2;
                if (SetAttributesRequest.a != 0) break block2;
                if (!sftpPacket3.getClass().equals(SshFxpStatus.class)) break block3;
                sftpPacket3 = sftpPacket2;
            }
            return SftpExceptionFactory.getException((SshFxpStatus)sftpPacket3, this.path);
        }
        return new RequestException(sftpPacket, sftpPacket2);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block9: {
            int n2;
            int n3;
            block8: {
                Object var0 = null;
                char[] cArray2 = "B\u0011?2\"B\u001bi!+Z\n, :".toCharArray();
                cArray = cArray2;
                n3 = cArray2.length;
                n2 = 0;
                if (!true) break block8;
                n3 = n3;
                if (n3 <= n2) break block9;
            }
            do {
                int n4;
                cArray = cArray;
                int n5 = n2;
                char c2 = cArray[n5];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 43;
                        break;
                    }
                    case 1: {
                        n4 = 127;
                        break;
                    }
                    case 2: {
                        n4 = 73;
                        break;
                    }
                    case 3: {
                        n4 = 83;
                        break;
                    }
                    default: {
                        n4 = 78;
                    }
                }
                cArray[n5] = (char)(c2 ^ n4);
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        z = new String(cArray).intern();
    }
}

