/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.inet.sftp;

import com.jscape.inet.file.JFile;
import com.jscape.inet.file.JFileInputStream;
import com.jscape.inet.file.JFileOutputStream;
import com.jscape.inet.sftp.RequestException;
import com.jscape.inet.sftp.Sftp;
import com.jscape.inet.sftp.SftpException;
import com.jscape.inet.sftp.SftpExceptionFactory;
import com.jscape.inet.sftp.events.SftpDownloadEvent;
import com.jscape.inet.sftp.events.SftpProgressEvent;
import com.jscape.inet.sftp.events.SftpUploadEvent;
import com.jscape.util.x;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class Sftp$TransferMode {
    protected final int code;
    protected String fileName;
    protected int eventMode;
    protected long endTime;
    protected long startTime;
    protected long totalBytes;
    protected long transferredBytes;
    protected long readBytes;
    final Sftp a;

    protected Sftp$TransferMode(Sftp sftp, int n2) {
        this.a = sftp;
        this.fileName = null;
        this.eventMode = 0;
        this.endTime = 0L;
        this.startTime = 0L;
        this.totalBytes = 0L;
        this.transferredBytes = 0L;
        this.readBytes = 0L;
        this.code = n2;
    }

    public final int getCode() {
        return this.code;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void download(JFile jFile, JFile jFile2, long l2) throws SftpException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = this.openIn(jFile, l2);
            outputStream = this.openOut(jFile2, l2);
            this.a(inputStream, outputStream, jFile.getFilename(), jFile.getFilesize() - l2);
        }
        catch (RequestException requestException) {
            try {
                throw SftpExceptionFactory.getException(requestException, jFile.getFilename());
                catch (IOException iOException) {
                    throw new SftpException(iOException.getMessage(), iOException);
                }
            }
            catch (Throwable throwable) {
                x.a(inputStream);
                x.a(outputStream);
                throw throwable;
            }
        }
        x.a(inputStream);
        x.a(outputStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void download(JFile jFile, OutputStream outputStream, long l2) throws SftpException {
        JFileInputStream jFileInputStream = null;
        try {
            long l3 = jFile.getFilesize();
            jFileInputStream = new JFileInputStream(jFile, l2);
            this.a(jFileInputStream, outputStream, jFile.getFilename(), l3 - l2);
        }
        catch (RequestException requestException) {
            try {
                throw SftpExceptionFactory.getException(requestException, jFile.getFilename());
                catch (IOException iOException) {
                    throw new SftpException(iOException.getMessage(), iOException);
                }
            }
            catch (Throwable throwable) {
                x.a(jFileInputStream);
                throw throwable;
            }
        }
        x.a(jFileInputStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void upload(JFile jFile, JFile jFile2, long l2) throws SftpException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = this.openIn(jFile, l2);
            outputStream = this.openOut(jFile2, l2);
            this.b(inputStream, outputStream, jFile.getFilename(), jFile.getFilesize() - l2);
        }
        catch (RequestException requestException) {
            try {
                throw SftpExceptionFactory.getException(requestException, jFile2.getFilename());
                catch (IOException iOException) {
                    throw new SftpException(iOException.getMessage(), iOException);
                }
            }
            catch (Throwable throwable) {
                x.a(inputStream);
                x.a(outputStream);
                throw throwable;
            }
        }
        x.a(inputStream);
        x.a(outputStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void upload(InputStream inputStream, JFile jFile, long l2) throws SftpException {
        OutputStream outputStream = null;
        try {
            outputStream = this.openOut(jFile, l2);
            this.b(inputStream, outputStream, jFile.getFilename(), inputStream.available());
        }
        catch (RequestException requestException) {
            try {
                throw SftpExceptionFactory.getException(requestException, jFile.getFilename());
                catch (IOException iOException) {
                    throw new SftpException(iOException.getMessage(), iOException);
                }
            }
            catch (Throwable throwable) {
                x.a(outputStream);
                throw throwable;
            }
        }
        x.a(outputStream);
    }

    protected void copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws SftpException {
    }

    protected void fireProgressEvent() {
        SftpProgressEvent sftpProgressEvent = new SftpProgressEvent(this.a, this.fileName, Sftp.h(this.a).getPath(), this.eventMode, this.transferredBytes, this.readBytes, this.totalBytes);
        Sftp.a(this.a, sftpProgressEvent);
    }

    protected InputStream openIn(JFile jFile, long l2) throws IOException {
        return new JFileInputStream(jFile, l2);
    }

    protected OutputStream openOut(JFile jFile, long l2) throws IOException {
        return new JFileOutputStream(jFile, l2);
    }

    private void a(InputStream inputStream, OutputStream outputStream, String string, long l2) throws SftpException {
        this.fileName = string;
        this.totalBytes = l2;
        this.eventMode = 1;
        this.copy(inputStream, outputStream, Sftp.i(this.a));
        this.b();
    }

    private void b() {
        Sftp.a(this.a, new SftpDownloadEvent(this.a, this.fileName, Sftp.h(this.a).getPath(), "", this.transferredBytes, this.endTime - this.startTime));
    }

    private void c() {
        Sftp.a(this.a, new SftpUploadEvent(this.a, this.fileName, Sftp.h(this.a).getPath(), "", this.transferredBytes, this.endTime - this.startTime));
    }

    private void b(InputStream inputStream, OutputStream outputStream, String string, long l2) throws SftpException {
        this.fileName = string;
        this.totalBytes = l2;
        this.eventMode = 0;
        this.copy(inputStream, outputStream, Sftp.j(this.a));
        this.c();
    }
}

