/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class RemoveByList
extends Task {
    private static final int DELETE_RETRY_SLEEP_MILLIS = 10;
    private File filelist;

    public void setFilelist(File filelist) {
        this.filelist = filelist;
    }

    public void execute() throws BuildException {
        if (this.filelist == null) {
            throw new BuildException("filelist attribute is required", this.getLocation());
        }
        if (!this.filelist.exists()) {
            throw new BuildException("filelist does not exists! (Path:" + this.filelist.getAbsolutePath() + ")", this.getLocation());
        }
        ArrayList alTargetDir = new ArrayList();
        try {
            alTargetDir = this.extractFileList(this.filelist);
        }
        catch (Exception exp) {
            throw new BuildException("Exception raised when extracting config directories: " + exp.getMessage(), this.getLocation());
        }
        for (File fConfigHome : alTargetDir) {
            if (!fConfigHome.exists() || !fConfigHome.isDirectory()) continue;
            this.removeDir(fConfigHome);
        }
    }

    private ArrayList extractFileList(File fTargetFile) throws FileNotFoundException, IOException {
        ArrayList<File> alReturn = new ArrayList<File>();
        try {
            String sLine;
            alReturn = new ArrayList();
            BufferedReader br = new BufferedReader(new FileReader(fTargetFile));
            while ((sLine = br.readLine()) != null) {
                File fConfigHome = new File(sLine);
                alReturn.add(fConfigHome);
            }
            br.close();
        }
        catch (IOException ioExpt) {
            throw new IOException(ioExpt.getMessage());
        }
        return alReturn;
    }

    protected void removeDir(File d) {
        System.out.println("Try to remove direcotry " + d.getAbsolutePath());
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            File f = new File(d, s);
            if (f.isDirectory()) {
                this.removeDir(f);
                continue;
            }
            if (this.delete(f)) continue;
            String message = "Unable to delete file " + f.getAbsolutePath();
            System.out.println(message);
        }
        if (!this.delete(d)) {
            System.out.println("Unable to delete directory " + d.getAbsolutePath());
        } else {
            System.out.println("Removed directory at " + d.getAbsolutePath());
        }
    }

    private boolean delete(File f) {
        if (!f.delete()) {
            System.gc();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!f.delete()) {
                f.deleteOnExit();
                return true;
            }
        }
        return true;
    }
}

